/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.ServerConfiguration;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.app.TwoPortService;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.conf.store.CodeStoreRegistry;
import ca.uhn.hl7v2.conf.store.DefaultCodeStoreRegistry;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.conf.store.ProfileStoreFactory;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.SocketFactory;
import ca.uhn.hl7v2.util.StandardSocketFactory;
import ca.uhn.hl7v2.validation.DefaultValidationExceptionHandler;
import ca.uhn.hl7v2.validation.DefaultValidator;
import ca.uhn.hl7v2.validation.ReportingValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import ca.uhn.hl7v2.validation.Validator;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHapiContext
implements HapiContext {
    private ExecutorService executorService;
    private ParserConfiguration parserConfiguration;
    private ValidationContext validationContext;
    private ValidationRuleBuilder validationRuleBuilder;
    private ModelClassFactory modelClassFactory;
    private ConnectionHub connectionHub;
    private LowerLayerProtocol llp;
    private SocketFactory socketFactory;
    private ProfileStore profileStore;
    private CodeStoreRegistry codeStoreRegistry;
    private PipeParser pipeParser;
    private XMLParser xmlParser;
    private GenericParser genericParser;
    private Validator<?> validator;
    private ValidationExceptionHandlerFactory<?> validationExceptionHandlerFactory;
    private ServerConfiguration serverConfiguration;

    public DefaultHapiContext() {
        this(new DefaultModelClassFactory());
    }

    public DefaultHapiContext(ExecutorService executorService) {
        this();
        this.setExecutorService(executorService);
    }

    public DefaultHapiContext(ModelClassFactory modelClassFactory) {
        this(new ParserConfiguration(), (ValidationContext)ValidationContextFactory.defaultValidation(), modelClassFactory);
    }

    public DefaultHapiContext(ValidationContext validationContext) {
        this(new ParserConfiguration(), validationContext, (ModelClassFactory)new DefaultModelClassFactory());
    }

    public DefaultHapiContext(ValidationRuleBuilder builder) {
        this(new ParserConfiguration(), builder, (ModelClassFactory)new DefaultModelClassFactory());
    }

    public DefaultHapiContext(ParserConfiguration parserConfiguration, ValidationContext validationContext, ModelClassFactory modelClassFactory) {
        VersionLogger.init();
        this.setParserConfiguration(parserConfiguration);
        this.setValidationContext(validationContext);
        this.setModelClassFactory(modelClassFactory);
        this.setLowerLayerProtocol(new MinLowerLayerProtocol(false));
        this.setSocketFactory(new StandardSocketFactory());
        this.setValidationExceptionHandlerFactory(new ReportingValidationExceptionHandler(true));
        this.setProfileStore(ProfileStoreFactory.getProfileStore());
        this.setCodeStoreRegistry(new DefaultCodeStoreRegistry());
        this.setServerConfiguration(new ServerConfiguration());
    }

    public DefaultHapiContext(ParserConfiguration parserConfiguration, ValidationRuleBuilder builder, ModelClassFactory modelClassFactory) {
        VersionLogger.init();
        this.setParserConfiguration(parserConfiguration);
        this.setValidationRuleBuilder(builder);
        this.setModelClassFactory(modelClassFactory);
        this.setLowerLayerProtocol(new MinLowerLayerProtocol(false));
        this.setSocketFactory(new StandardSocketFactory());
        this.setProfileStore(ProfileStoreFactory.getProfileStore());
        this.setCodeStoreRegistry(new DefaultCodeStoreRegistry());
        this.setServerConfiguration(new ServerConfiguration());
    }

    public DefaultHapiContext(HapiContext context) {
        this(context.getParserConfiguration(), context.getValidationContext(), context.getModelClassFactory());
    }

    @Override
    public void close() throws IOException {
        this.getConnectionHub().discardAll();
        if (DefaultExecutorService.isDefaultService(this.executorService)) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = DefaultExecutorService.getDefaultService();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    DefaultHapiContext.this.executorService.shutdownNow();
                }
            });
        }
        return this.executorService;
    }

    @Override
    public synchronized void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ConnectionHub getConnectionHub() {
        if (this.connectionHub == null) {
            this.connectionHub = ConnectionHub.getNewInstance(this);
        }
        return this.connectionHub;
    }

    @Override
    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    @Override
    public void setParserConfiguration(ParserConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("ParserConfiguration must not be null");
        }
        this.parserConfiguration = configuration;
    }

    @Override
    public ValidationContext getValidationContext() {
        if (this.validationContext == null) {
            if (this.getValidationRuleBuilder() != null) {
                this.setValidationContext(ValidationContextFactory.fromBuilder(this.getValidationRuleBuilder()));
            } else {
                try {
                    this.setValidationContext(ValidationContextFactory.getContext());
                }
                catch (HL7Exception e) {
                    this.setValidationContext((ValidationContext)ValidationContextFactory.defaultValidation());
                }
            }
        }
        return this.validationContext;
    }

    @Override
    public void setValidationContext(ValidationContext context) {
        this.validationContext = context;
    }

    @Override
    public void setValidationContext(String contextClassName) {
        try {
            this.validationContext = ValidationContextFactory.customValidation(contextClassName);
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ValidationRuleBuilder getValidationRuleBuilder() {
        return this.validationRuleBuilder;
    }

    @Override
    public void setValidationRuleBuilder(ValidationRuleBuilder validationRuleBuilder) {
        this.validationRuleBuilder = validationRuleBuilder;
        this.setValidationContext(ValidationContextFactory.fromBuilder(validationRuleBuilder));
    }

    @Override
    public void setValidationRuleBuilder(String builderClassName) {
        try {
            this.setValidationRuleBuilder(ValidationContextFactory.customBuilder(builderClassName));
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ModelClassFactory getModelClassFactory() {
        return this.modelClassFactory == null ? new DefaultModelClassFactory() : this.modelClassFactory;
    }

    @Override
    public void setModelClassFactory(ModelClassFactory modelClassFactory) {
        this.modelClassFactory = modelClassFactory;
    }

    @Override
    public ProfileStore getProfileStore() {
        return this.profileStore;
    }

    @Override
    public void setProfileStore(ProfileStore profileStore) {
        this.profileStore = profileStore;
    }

    @Override
    public CodeStoreRegistry getCodeStoreRegistry() {
        return this.codeStoreRegistry;
    }

    @Override
    public void setCodeStoreRegistry(CodeStoreRegistry codeStoreRegistry) {
        this.codeStoreRegistry = codeStoreRegistry;
    }

    @Override
    public ca.uhn.hl7v2.conf.check.Validator getConformanceValidator() {
        return new ca.uhn.hl7v2.conf.check.DefaultValidator(this);
    }

    @Override
    public synchronized PipeParser getPipeParser() {
        if (this.pipeParser == null) {
            this.pipeParser = new PipeParser(this);
        }
        return this.pipeParser;
    }

    @Override
    public synchronized XMLParser getXMLParser() {
        if (this.xmlParser == null) {
            this.xmlParser = new DefaultXMLParser(this);
        }
        return this.xmlParser;
    }

    @Override
    public synchronized GenericParser getGenericParser() {
        if (this.genericParser == null) {
            this.genericParser = new GenericParser(this);
        }
        return this.genericParser;
    }

    @Override
    public synchronized <R> Validator<R> getMessageValidator() {
        if (this.validator == null) {
            this.validator = new DefaultValidator(this);
        }
        return this.validator;
    }

    @Override
    public <R> ValidationExceptionHandlerFactory<R> getValidationExceptionHandlerFactory() {
        if (this.validationExceptionHandlerFactory == null) {
            this.validationExceptionHandlerFactory = new DefaultValidationExceptionHandler(this);
        }
        return this.validationExceptionHandlerFactory;
    }

    @Override
    public <R> void setValidationExceptionHandlerFactory(ValidationExceptionHandlerFactory<R> factory) {
        if (factory == null) {
            throw new NullPointerException("ValidationExceptionHandlerFactory can not be null");
        }
        this.validationExceptionHandlerFactory = factory;
    }

    @Override
    public LowerLayerProtocol getLowerLayerProtocol() {
        return this.llp;
    }

    @Override
    public void setLowerLayerProtocol(LowerLayerProtocol llp) {
        this.llp = llp;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public SimpleServer newServer(int port, boolean tls) {
        return new SimpleServer(this, port, tls);
    }

    @Override
    public TwoPortService newServer(int port1, int port2, boolean tls) {
        return new TwoPortService(this, port1, port2, tls);
    }

    @Override
    public Connection newClient(String host, int port, boolean tls) throws HL7Exception {
        return this.getConnectionHub().attach(this, host, port, tls);
    }

    @Override
    public Connection newClient(String host, int outboundPort, int inboundPort, boolean tls) throws HL7Exception {
        return this.getConnectionHub().attach(this, host, outboundPort, inboundPort, tls);
    }

    @Override
    public Connection newLazyClient(String host, int port, boolean tls) throws HL7Exception {
        return this.getConnectionHub().attachLazily(this, host, port, tls);
    }

    @Override
    public Connection newLazyClient(String host, int outboundPort, int inboundPort, boolean tls) throws HL7Exception {
        return this.getConnectionHub().attachLazily(this, host, outboundPort, inboundPort, tls);
    }

    @Override
    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public void setServerConfiguration(ServerConfiguration theServerConfiguration) {
        if (theServerConfiguration == null) {
            throw new NullPointerException("Server configuration can not be null");
        }
        this.serverConfiguration = theServerConfiguration;
    }
}

