/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.AcceptorThread;
import ca.uhn.hl7v2.app.ActiveConnection;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.SocketFactory;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPortService
extends HL7Service {
    private static final Logger log = LoggerFactory.getLogger(TwoPortService.class);
    private Map<String, AcceptorThread.AcceptedSocket> waitingForSecondSocket = new HashMap<String, AcceptorThread.AcceptedSocket>();
    private int inboundPort;
    private int outboundPort;
    private boolean tls;
    private BlockingQueue<AcceptorThread.AcceptedSocket> queue;
    private AcceptorThread inboundAcceptor;
    private AcceptorThread outboundAcceptor;
    private final HapiContext hapiContext;

    public TwoPortService(int inboundPort, int outboundPort) {
        this(new PipeParser(), new MinLowerLayerProtocol(), inboundPort, outboundPort, false);
    }

    public TwoPortService(int inboundPort, int outboundPort, boolean tls) {
        this(new PipeParser(), new MinLowerLayerProtocol(), inboundPort, outboundPort, tls);
    }

    public TwoPortService(Parser parser, LowerLayerProtocol llp, int inboundPort, int outboundPort, boolean tls) {
        this(parser, llp, inboundPort, outboundPort, tls, DefaultExecutorService.getDefaultService());
    }

    public TwoPortService(HapiContext hapiContext, int inboundPort, int outboundPort, boolean tls) {
        super(hapiContext);
        this.hapiContext = hapiContext;
        this.queue = new LinkedBlockingQueue<AcceptorThread.AcceptedSocket>();
        this.inboundPort = inboundPort;
        this.outboundPort = outboundPort;
        this.tls = tls;
        if (inboundPort == outboundPort) {
            throw new IllegalArgumentException("Inbound port and outbound port can not be the same");
        }
        if (inboundPort < 1) {
            throw new IllegalArgumentException("Invalid inbound port");
        }
        if (outboundPort < 1) {
            throw new IllegalArgumentException("Invalid outbound port");
        }
    }

    public TwoPortService(Parser parser, LowerLayerProtocol llp, int inboundPort, int outboundPort, boolean tls, ExecutorService executorService) {
        super(parser, llp, executorService);
        this.hapiContext = new DefaultHapiContext();
        this.queue = new LinkedBlockingQueue<AcceptorThread.AcceptedSocket>();
        this.inboundPort = inboundPort;
        this.outboundPort = outboundPort;
        this.tls = tls;
    }

    protected void afterStartup() {
        try {
            super.afterStartup();
            this.inboundAcceptor = this.createAcceptThread(this.inboundPort);
            this.outboundAcceptor = this.createAcceptThread(this.outboundPort);
            this.inboundAcceptor.start();
            this.outboundAcceptor.start();
            log.info("TwoPortService running on ports {} and {}", (Object)this.inboundPort, (Object)this.outboundPort);
        }
        catch (IOException e) {
            log.error("Could not run TwoPortService on ports {} and {}", (Object)this.inboundPort, (Object)this.outboundPort);
            throw new RuntimeException(e);
        }
    }

    protected void afterTermination() {
        super.afterTermination();
        this.inboundAcceptor.stop();
        this.outboundAcceptor.stop();
    }

    protected void handle() {
        if (this.inboundAcceptor.getServiceExitedWithException() != null) {
            this.setServiceExitedWithException(this.inboundAcceptor.getServiceExitedWithException());
        }
        if (this.outboundAcceptor.getServiceExitedWithException() != null) {
            this.setServiceExitedWithException(this.outboundAcceptor.getServiceExitedWithException());
        }
        try {
            ActiveConnection conn = this.acceptConnection(this.queue.poll(2L, TimeUnit.SECONDS));
            if (conn != null) {
                log.info("Accepted connection from " + conn.getRemoteAddress().getHostAddress());
                this.newConnection(conn);
            }
        }
        catch (Exception e) {
            log.error("Error while accepting connections: ", (Throwable)e);
        }
    }

    private ActiveConnection acceptConnection(AcceptorThread.AcceptedSocket newSocket) throws LLPException, IOException {
        ActiveConnection conn = null;
        if (newSocket != null) {
            String address = newSocket.socket.getInetAddress().getHostAddress();
            AcceptorThread.AcceptedSocket otherSocket = this.waitingForSecondSocket.remove(address);
            if (otherSocket != null && otherSocket.origin != newSocket.origin) {
                log.debug("Socket {} completes a two-port connection", (Object)newSocket.socket);
                Socket in = this.getInboundSocket(newSocket, otherSocket);
                Socket out = this.getOutboundSocket(newSocket, otherSocket);
                conn = new ActiveConnection(this.getParser(), this.getLlp(), in, out, this.getExecutorService());
            } else {
                log.debug("Registered {} Still waiting for second socket for two-port connection", (Object)newSocket.socket);
                this.waitingForSecondSocket.put(address, newSocket);
            }
        }
        return conn;
    }

    private Socket getInboundSocket(AcceptorThread.AcceptedSocket socket1, AcceptorThread.AcceptedSocket socket2) {
        return socket1.origin == this.inboundAcceptor ? socket1.socket : socket2.socket;
    }

    private Socket getOutboundSocket(AcceptorThread.AcceptedSocket socket1, AcceptorThread.AcceptedSocket socket2) {
        return socket1.origin == this.outboundAcceptor ? socket1.socket : socket2.socket;
    }

    protected AcceptorThread createAcceptThread(int port) throws SocketException, IOException {
        SocketFactory ss = this.hapiContext.getSocketFactory();
        return new AcceptorThread(port, this.tls, this.getExecutorService(), this.queue, ss);
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage: ca.uhn.hl7v2.app.TwoPortService inbound_port outbound_port [application_spec_file_name]");
            System.exit(1);
        }
        int inPort = 0;
        int outPort = 0;
        try {
            inPort = Integer.parseInt(args[0]);
            outPort = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.err.println("One of the given ports (" + args[0] + " or " + args[1] + ") is not an integer.");
            System.exit(1);
        }
        File appFile = null;
        if (args.length == 3) {
            appFile = new File(args[2]);
        }
        try {
            TwoPortService server = new TwoPortService(inPort, outPort);
            if (appFile != null) {
                server.loadApplicationsFromFile(appFile);
            }
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

