/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComposite
extends AbstractType
implements Composite {
    private static final long serialVersionUID = -2657103285266475699L;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractComposite(Message message) {
        super(message);
    }

    @Override
    public void clear() {
        super.clear();
        for (Type component : this.getComponents()) {
            component.clear();
        }
    }

    protected <T extends Type> T getTyped(int idx, Class<T> type) {
        try {
            Type ret = this.getComponent(idx);
            return (T)ret;
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() throws HL7Exception {
        for (Type type : this.getComponents()) {
            if (type.isEmpty()) continue;
            return false;
        }
        return super.isEmpty();
    }

    @Override
    public boolean accept(MessageVisitor visitor, Location location) throws HL7Exception {
        if (visitor.start(this, location)) {
            Location nextLocation;
            Varies v;
            Location nextLocation2;
            Type t;
            Type[] types = this.getComponents();
            for (int i = 0; i < types.length && (t = this.getComponent(i)).accept(visitor, nextLocation2 = t.provideLocation(location, i + 1, -1)); ++i) {
            }
            ExtraComponents ec = this.getExtraComponents();
            for (int i = 0; i < ec.numComponents() && (v = ec.getComponent(i)).accept(visitor, nextLocation = v.provideLocation(location, i + types.length, -1)); ++i) {
            }
        }
        return visitor.end(this, location);
    }
}

