/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.CQ_QUANTITY;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXD
extends AbstractSegment {
    public RXD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Dispense / give code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date / time dispensed");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Actual Dispense Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Actual Dispense Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Actual Dosage Form");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(ST.class, false, 0, 200, new Object[]{this.getMessage()}, "Dispense Notes");
            this.add(CN.class, false, 1, 200, new Object[]{this.getMessage()}, "Dispensing Provider");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(CQ_QUANTITY.class, false, 1, 10, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(CM_LA1.class, false, 1, 12, new Object[]{this.getMessage()}, "Deliver-to location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Needs Human Review");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Pharmacy Special Dispensing Instructions");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxd1_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getDispenseGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRxd2_DispenseGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimeDispensed() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getRxd3_DateTimeDispensed() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxd4_ActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getActualDispenseUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxd5_ActualDispenseUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getActualDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRxd6_ActualDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getRxd7_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getRxd8_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public ST[] getDispenseNotes() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public ST[] getRxd9_DispenseNotes() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public int getDispenseNotesReps() {
        return this.getReps(9);
    }

    public ST getDispenseNotes(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public ST getRxd9_DispenseNotes(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxd9_DispenseNotesReps() {
        return this.getReps(9);
    }

    public ST insertDispenseNotes(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST insertRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST removeDispenseNotes(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST removeRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public CN getDispensingProvider() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getRxd10_DispensingProvider() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getRxd11_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ_QUANTITY getTotalDailyDose() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ_QUANTITY getRxd12_TotalDailyDose() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(12, 0);
        return retVal;
    }

    public CM_LA1 getDeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(13, 0);
        return retVal;
    }

    public CM_LA1 getRxd13_DeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getRxd14_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getPharmacySpecialDispensingInstructions() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getRxd15_PharmacySpecialDispensingInstructions() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 11: {
                return new CQ_QUANTITY(this.getMessage());
            }
            case 12: {
                return new CM_LA1(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 14: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

