/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_DIN;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class STF
extends AbstractSegment {
    public STF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "STF - primary key value");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Staff ID Code");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Staff Name");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(182)}, "Staff Type");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date of Birth");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active / inactive");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Department");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Service");
            this.add(TN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone");
            this.add(AD.class, false, 2, 106, new Object[]{this.getMessage()}, "Office / home address");
            this.add(CM_DIN.class, false, 0, 19, new Object[]{this.getMessage()}, "Activation Date");
            this.add(CM_DIN.class, false, 0, 19, new Object[]{this.getMessage()}, "Inactivation Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Backup Person ID");
            this.add(ST.class, false, 0, 40, new Object[]{this.getMessage()}, "E-mail Address");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(185)}, "Preferred method of Contact");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating STF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getSTFPrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getStf1_STFPrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getStaffIDCode() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getStf2_StaffIDCode() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getStaffIDCodeReps() {
        return this.getReps(2);
    }

    public CE getStaffIDCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getStf2_StaffIDCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getStf2_StaffIDCodeReps() {
        return this.getReps(2);
    }

    public CE insertStaffIDCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeStaffIDCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public PN getStaffName() {
        PN retVal = (PN)this.getTypedField(3, 0);
        return retVal;
    }

    public PN getStf3_StaffName() {
        PN retVal = (PN)this.getTypedField(3, 0);
        return retVal;
    }

    public ID[] getStaffType() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public ID[] getStf4_StaffType() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public int getStaffTypeReps() {
        return this.getReps(4);
    }

    public ID getStaffType(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getStf4_StaffType(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getStf4_StaffTypeReps() {
        return this.getReps(4);
    }

    public ID insertStaffType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertStf4_StaffType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removeStaffType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removeStf4_StaffType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID getSex() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getStf5_Sex() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDateOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getStf6_DateOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getActiveInactive() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getStf7_ActiveInactive() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CE[] getDepartment() {
        CE[] retVal = (CE[])this.getTypedField(8, new CE[0]);
        return retVal;
    }

    public CE[] getStf8_Department() {
        CE[] retVal = (CE[])this.getTypedField(8, new CE[0]);
        return retVal;
    }

    public int getDepartmentReps() {
        return this.getReps(8);
    }

    public CE getDepartment(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public CE getStf8_Department(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getStf8_DepartmentReps() {
        return this.getReps(8);
    }

    public CE insertDepartment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE insertStf8_Department(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE removeDepartment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE removeStf8_Department(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE[] getService() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getStf9_Service() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getServiceReps() {
        return this.getReps(9);
    }

    public CE getService(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getStf9_Service(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getStf9_ServiceReps() {
        return this.getReps(9);
    }

    public CE insertService(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertStf9_Service(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeService(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeStf9_Service(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public TN[] getPhone() {
        TN[] retVal = (TN[])this.getTypedField(10, new TN[0]);
        return retVal;
    }

    public TN[] getStf10_Phone() {
        TN[] retVal = (TN[])this.getTypedField(10, new TN[0]);
        return retVal;
    }

    public int getPhoneReps() {
        return this.getReps(10);
    }

    public TN getPhone(int rep) {
        TN retVal = (TN)this.getTypedField(10, rep);
        return retVal;
    }

    public TN getStf10_Phone(int rep) {
        TN retVal = (TN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getStf10_PhoneReps() {
        return this.getReps(10);
    }

    public TN insertPhone(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(10, rep);
    }

    public TN insertStf10_Phone(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(10, rep);
    }

    public TN removePhone(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(10, rep);
    }

    public TN removeStf10_Phone(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(10, rep);
    }

    public AD[] getOfficeHomeAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, new AD[0]);
        return retVal;
    }

    public AD[] getStf11_OfficeHomeAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, new AD[0]);
        return retVal;
    }

    public int getOfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public AD getOfficeHomeAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public AD getStf11_OfficeHomeAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getStf11_OfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public AD insertOfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD insertStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD removeOfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public AD removeStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public CM_DIN[] getActivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(12, new CM_DIN[0]);
        return retVal;
    }

    public CM_DIN[] getStf12_ActivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(12, new CM_DIN[0]);
        return retVal;
    }

    public int getActivationDateReps() {
        return this.getReps(12);
    }

    public CM_DIN getActivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public CM_DIN getStf12_ActivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getStf12_ActivationDateReps() {
        return this.getReps(12);
    }

    public CM_DIN insertActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(12, rep);
    }

    public CM_DIN insertStf12_ActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(12, rep);
    }

    public CM_DIN removeActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(12, rep);
    }

    public CM_DIN removeStf12_ActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(12, rep);
    }

    public CM_DIN[] getInactivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(13, new CM_DIN[0]);
        return retVal;
    }

    public CM_DIN[] getStf13_InactivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(13, new CM_DIN[0]);
        return retVal;
    }

    public int getInactivationDateReps() {
        return this.getReps(13);
    }

    public CM_DIN getInactivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public CM_DIN getStf13_InactivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getStf13_InactivationDateReps() {
        return this.getReps(13);
    }

    public CM_DIN insertInactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(13, rep);
    }

    public CM_DIN insertStf13_InactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(13, rep);
    }

    public CM_DIN removeInactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(13, rep);
    }

    public CM_DIN removeStf13_InactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(13, rep);
    }

    public CE[] getBackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public CE[] getStf14_BackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public int getBackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE getBackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getStf14_BackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getStf14_BackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE insertBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removeStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public ST[] getEMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public ST[] getStf15_EMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public int getEMailAddressReps() {
        return this.getReps(15);
    }

    public ST getEMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public ST getStf15_EMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public int getStf15_EMailAddressReps() {
        return this.getReps(15);
    }

    public ST insertEMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST insertStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST removeEMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ST removeStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ID getPreferredMethodOfContact() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getStf16_PreferredMethodOfContact() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new PN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(182));
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(1));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new TN(this.getMessage());
            }
            case 10: {
                return new AD(this.getMessage());
            }
            case 11: {
                return new CM_DIN(this.getMessage());
            }
            case 12: {
                return new CM_DIN(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(185));
            }
        }
        return null;
    }
}

