/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.RDF;
import ca.uhn.hl7v2.model.v24.segment.RDT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBR_R08
extends AbstractMessage {
    public TBR_R08() {
        this(new DefaultModelClassFactory());
    }

    public TBR_R08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(RDF.class, true, false);
            this.add(RDT.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TBR_R08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public RDF getRDF() {
        return this.getTyped("RDF", RDF.class);
    }

    public RDT getRDT() {
        return this.getTyped("RDT", RDT.class);
    }

    public RDT getRDT(int rep) {
        return this.getTyped("RDT", rep, RDT.class);
    }

    public int getRDTReps() {
        return this.getReps("RDT");
    }

    public List<RDT> getRDTAll() throws HL7Exception {
        return this.getAllAsList("RDT", RDT.class);
    }

    public void insertRDT(RDT structure, int rep) throws HL7Exception {
        super.insertRepetition("RDT", structure, rep);
    }

    public RDT insertRDT(int rep) throws HL7Exception {
        return (RDT)super.insertRepetition("RDT", rep);
    }

    public RDT removeRDT(int rep) throws HL7Exception {
        return (RDT)super.removeRepetition("RDT", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

