/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.segment.AFF;
import ca.uhn.hl7v2.model.v25.segment.CER;
import ca.uhn.hl7v2.model.v25.segment.EDU;
import ca.uhn.hl7v2.model.v25.segment.LAN;
import ca.uhn.hl7v2.model.v25.segment.MFE;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.ORG;
import ca.uhn.hl7v2.model.v25.segment.PRA;
import ca.uhn.hl7v2.model.v25.segment.STF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M02_MF_STAFF
extends AbstractGroup {
    public MFN_M02_MF_STAFF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(STF.class, true, false, false);
            this.add(PRA.class, false, true, false);
            this.add(ORG.class, false, true, false);
            this.add(AFF.class, false, true, false);
            this.add(LAN.class, false, true, false);
            this.add(EDU.class, false, true, false);
            this.add(CER.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M02_MF_STAFF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public STF getSTF() {
        STF retVal = this.getTyped("STF", STF.class);
        return retVal;
    }

    public PRA getPRA() {
        PRA retVal = this.getTyped("PRA", PRA.class);
        return retVal;
    }

    public PRA getPRA(int rep) {
        PRA retVal = this.getTyped("PRA", rep, PRA.class);
        return retVal;
    }

    public int getPRAReps() {
        return this.getReps("PRA");
    }

    public List<PRA> getPRAAll() throws HL7Exception {
        return this.getAllAsList("PRA", PRA.class);
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        ORG retVal = this.getTyped("ORG", ORG.class);
        return retVal;
    }

    public ORG getORG(int rep) {
        ORG retVal = this.getTyped("ORG", rep, ORG.class);
        return retVal;
    }

    public int getORGReps() {
        return this.getReps("ORG");
    }

    public List<ORG> getORGAll() throws HL7Exception {
        return this.getAllAsList("ORG", ORG.class);
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }

    public AFF getAFF() {
        AFF retVal = this.getTyped("AFF", AFF.class);
        return retVal;
    }

    public AFF getAFF(int rep) {
        AFF retVal = this.getTyped("AFF", rep, AFF.class);
        return retVal;
    }

    public int getAFFReps() {
        return this.getReps("AFF");
    }

    public List<AFF> getAFFAll() throws HL7Exception {
        return this.getAllAsList("AFF", AFF.class);
    }

    public void insertAFF(AFF structure, int rep) throws HL7Exception {
        super.insertRepetition("AFF", structure, rep);
    }

    public AFF insertAFF(int rep) throws HL7Exception {
        return (AFF)super.insertRepetition("AFF", rep);
    }

    public AFF removeAFF(int rep) throws HL7Exception {
        return (AFF)super.removeRepetition("AFF", rep);
    }

    public LAN getLAN() {
        LAN retVal = this.getTyped("LAN", LAN.class);
        return retVal;
    }

    public LAN getLAN(int rep) {
        LAN retVal = this.getTyped("LAN", rep, LAN.class);
        return retVal;
    }

    public int getLANReps() {
        return this.getReps("LAN");
    }

    public List<LAN> getLANAll() throws HL7Exception {
        return this.getAllAsList("LAN", LAN.class);
    }

    public void insertLAN(LAN structure, int rep) throws HL7Exception {
        super.insertRepetition("LAN", structure, rep);
    }

    public LAN insertLAN(int rep) throws HL7Exception {
        return (LAN)super.insertRepetition("LAN", rep);
    }

    public LAN removeLAN(int rep) throws HL7Exception {
        return (LAN)super.removeRepetition("LAN", rep);
    }

    public EDU getEDU() {
        EDU retVal = this.getTyped("EDU", EDU.class);
        return retVal;
    }

    public EDU getEDU(int rep) {
        EDU retVal = this.getTyped("EDU", rep, EDU.class);
        return retVal;
    }

    public int getEDUReps() {
        return this.getReps("EDU");
    }

    public List<EDU> getEDUAll() throws HL7Exception {
        return this.getAllAsList("EDU", EDU.class);
    }

    public void insertEDU(EDU structure, int rep) throws HL7Exception {
        super.insertRepetition("EDU", structure, rep);
    }

    public EDU insertEDU(int rep) throws HL7Exception {
        return (EDU)super.insertRepetition("EDU", rep);
    }

    public EDU removeEDU(int rep) throws HL7Exception {
        return (EDU)super.removeRepetition("EDU", rep);
    }

    public CER getCER() {
        CER retVal = this.getTyped("CER", CER.class);
        return retVal;
    }

    public CER getCER(int rep) {
        CER retVal = this.getTyped("CER", rep, CER.class);
        return retVal;
    }

    public int getCERReps() {
        return this.getReps("CER");
    }

    public List<CER> getCERAll() throws HL7Exception {
        return this.getAllAsList("CER", CER.class);
    }

    public void insertCER(CER structure, int rep) throws HL7Exception {
        super.insertRepetition("CER", structure, rep);
    }

    public CER insertCER(int rep) throws HL7Exception {
        return (CER)super.insertRepetition("CER", rep);
    }

    public CER removeCER(int rep) throws HL7Exception {
        return (CER)super.removeRepetition("CER", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

