/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.RRI_I12_AUTHORIZATION_CONTACT;
import ca.uhn.hl7v2.model.v25.group.RRI_I12_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.RRI_I12_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v25.group.RRI_I12_PROCEDURE;
import ca.uhn.hl7v2.model.v25.group.RRI_I12_PROVIDER_CONTACT;
import ca.uhn.hl7v2.model.v25.segment.ACC;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.DG1;
import ca.uhn.hl7v2.model.v25.segment.DRG;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.RF1;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRI_I12
extends AbstractMessage {
    public RRI_I12() {
        this(new DefaultModelClassFactory());
    }

    public RRI_I12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, false, false);
            this.add(RF1.class, false, false);
            this.add(RRI_I12_AUTHORIZATION_CONTACT.class, false, false);
            this.add(RRI_I12_PROVIDER_CONTACT.class, true, true);
            this.add(PID.class, true, false);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RRI_I12_PROCEDURE.class, false, true);
            this.add(RRI_I12_OBSERVATION.class, false, true);
            this.add(RRI_I12_PATIENT_VISIT.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRI_I12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RF1 getRF1() {
        return this.getTyped("RF1", RF1.class);
    }

    public RRI_I12_AUTHORIZATION_CONTACT getAUTHORIZATION_CONTACT() {
        return this.getTyped("AUTHORIZATION_CONTACT", RRI_I12_AUTHORIZATION_CONTACT.class);
    }

    public RRI_I12_PROVIDER_CONTACT getPROVIDER_CONTACT() {
        return this.getTyped("PROVIDER_CONTACT", RRI_I12_PROVIDER_CONTACT.class);
    }

    public RRI_I12_PROVIDER_CONTACT getPROVIDER_CONTACT(int rep) {
        return this.getTyped("PROVIDER_CONTACT", rep, RRI_I12_PROVIDER_CONTACT.class);
    }

    public int getPROVIDER_CONTACTReps() {
        return this.getReps("PROVIDER_CONTACT");
    }

    public List<RRI_I12_PROVIDER_CONTACT> getPROVIDER_CONTACTAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER_CONTACT", RRI_I12_PROVIDER_CONTACT.class);
    }

    public void insertPROVIDER_CONTACT(RRI_I12_PROVIDER_CONTACT structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER_CONTACT", structure, rep);
    }

    public RRI_I12_PROVIDER_CONTACT insertPROVIDER_CONTACT(int rep) throws HL7Exception {
        return (RRI_I12_PROVIDER_CONTACT)super.insertRepetition("PROVIDER_CONTACT", rep);
    }

    public RRI_I12_PROVIDER_CONTACT removePROVIDER_CONTACT(int rep) throws HL7Exception {
        return (RRI_I12_PROVIDER_CONTACT)super.removeRepetition("PROVIDER_CONTACT", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public ACC getACC() {
        return this.getTyped("ACC", ACC.class);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RRI_I12_PROCEDURE getPROCEDURE() {
        return this.getTyped("PROCEDURE", RRI_I12_PROCEDURE.class);
    }

    public RRI_I12_PROCEDURE getPROCEDURE(int rep) {
        return this.getTyped("PROCEDURE", rep, RRI_I12_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<RRI_I12_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", RRI_I12_PROCEDURE.class);
    }

    public void insertPROCEDURE(RRI_I12_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public RRI_I12_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RRI_I12_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RRI_I12_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RRI_I12_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RRI_I12_OBSERVATION getOBSERVATION() {
        return this.getTyped("OBSERVATION", RRI_I12_OBSERVATION.class);
    }

    public RRI_I12_OBSERVATION getOBSERVATION(int rep) {
        return this.getTyped("OBSERVATION", rep, RRI_I12_OBSERVATION.class);
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RRI_I12_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RRI_I12_OBSERVATION.class);
    }

    public void insertOBSERVATION(RRI_I12_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RRI_I12_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RRI_I12_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RRI_I12_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RRI_I12_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public RRI_I12_PATIENT_VISIT getPATIENT_VISIT() {
        return this.getTyped("PATIENT_VISIT", RRI_I12_PATIENT_VISIT.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

