/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.segment.IN1;
import ca.uhn.hl7v2.model.v251.segment.IN2;
import ca.uhn.hl7v2.model.v251.segment.IN3;
import ca.uhn.hl7v2.model.v251.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A05_INSURANCE
extends AbstractGroup {
    public ADT_A05_INSURANCE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IN1.class, true, false, false);
            this.add(IN2.class, false, false, false);
            this.add(IN3.class, false, true, false);
            this.add(ROL.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A05_INSURANCE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public IN1 getIN1() {
        IN1 retVal = this.getTyped("IN1", IN1.class);
        return retVal;
    }

    public IN2 getIN2() {
        IN2 retVal = this.getTyped("IN2", IN2.class);
        return retVal;
    }

    public IN3 getIN3() {
        IN3 retVal = this.getTyped("IN3", IN3.class);
        return retVal;
    }

    public IN3 getIN3(int rep) {
        IN3 retVal = this.getTyped("IN3", rep, IN3.class);
        return retVal;
    }

    public int getIN3Reps() {
        return this.getReps("IN3");
    }

    public List<IN3> getIN3All() throws HL7Exception {
        return this.getAllAsList("IN3", IN3.class);
    }

    public void insertIN3(IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN3", structure, rep);
    }

    public IN3 insertIN3(int rep) throws HL7Exception {
        return (IN3)super.insertRepetition("IN3", rep);
    }

    public IN3 removeIN3(int rep) throws HL7Exception {
        return (IN3)super.removeRepetition("IN3", rep);
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }
}

