/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.ORM_O01_INSURANCE;
import ca.uhn.hl7v2.model.v251.group.ORM_O01_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.AL1;
import ca.uhn.hl7v2.model.v251.segment.GT1;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.PD1;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORM_O01_PATIENT
extends AbstractGroup {
    public ORM_O01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ORM_O01_PATIENT_VISIT.class, false, false, false);
            this.add(ORM_O01_INSURANCE.class, false, true, false);
            this.add(GT1.class, false, false, false);
            this.add(AL1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORM_O01_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORM_O01_PATIENT_VISIT getPATIENT_VISIT() {
        ORM_O01_PATIENT_VISIT retVal = this.getTyped("PATIENT_VISIT", ORM_O01_PATIENT_VISIT.class);
        return retVal;
    }

    public ORM_O01_INSURANCE getINSURANCE() {
        ORM_O01_INSURANCE retVal = this.getTyped("INSURANCE", ORM_O01_INSURANCE.class);
        return retVal;
    }

    public ORM_O01_INSURANCE getINSURANCE(int rep) {
        ORM_O01_INSURANCE retVal = this.getTyped("INSURANCE", rep, ORM_O01_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<ORM_O01_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ORM_O01_INSURANCE.class);
    }

    public void insertINSURANCE(ORM_O01_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public ORM_O01_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ORM_O01_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ORM_O01_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ORM_O01_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

