/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.PPP_PCB_PATHWAY;
import ca.uhn.hl7v2.model.v26.group.PPP_PCB_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPP_PCB
extends AbstractMessage {
    public PPP_PCB() {
        this(new DefaultModelClassFactory());
    }

    public PPP_PCB(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(PID.class, true, false);
            this.add(PPP_PCB_PATIENT_VISIT.class, false, false);
            this.add(PPP_PCB_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPP_PCB - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PPP_PCB_PATIENT_VISIT getPATIENT_VISIT() {
        return this.getTyped("PATIENT_VISIT", PPP_PCB_PATIENT_VISIT.class);
    }

    public PPP_PCB_PATHWAY getPATHWAY() {
        return this.getTyped("PATHWAY", PPP_PCB_PATHWAY.class);
    }

    public PPP_PCB_PATHWAY getPATHWAY(int rep) {
        return this.getTyped("PATHWAY", rep, PPP_PCB_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPP_PCB_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPP_PCB_PATHWAY.class);
    }

    public void insertPATHWAY(PPP_PCB_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public PPP_PCB_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPP_PCB_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

