/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM4
extends AbstractSegment {
    public OM4(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(170)}, "Derived Specimen");
            this.add(TX.class, false, 1, 60, new Object[]{this.getMessage()}, "Container Description");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Volume");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Container Units");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Specimen");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Additive");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Preparation");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Special Handling Requirements");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Normal Collection Volume");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Collection Volume");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Specimen Requirements");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(27)}, "Specimen Priorities");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Specimen Retention Time");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM4 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm41_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getDerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getOm42_DerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public TX getContainerDescription() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public TX getOm43_ContainerDescription() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getContainerVolume() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getOm44_ContainerVolume() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getContainerUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getOm45_ContainerUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getSpecimen() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getOm46_Specimen() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAdditive() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getOm47_Additive() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getPreparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getOm48_Preparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getSpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public TX getOm49_SpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getNormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getOm410_NormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getMinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getOm411_MinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public TX getSpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public TX getOm412_SpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public ID[] getSpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(13, new ID[0]);
        return retVal;
    }

    public ID[] getOm413_SpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(13, new ID[0]);
        return retVal;
    }

    public int getSpecimenPrioritiesReps() {
        return this.getReps(13);
    }

    public ID getSpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public ID getOm413_SpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public int getOm413_SpecimenPrioritiesReps() {
        return this.getReps(13);
    }

    public ID insertSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID insertOm413_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID removeSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    public ID removeOm413_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    public CQ getSpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getOm414_SpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(170));
            }
            case 2: {
                return new TX(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new TX(this.getMessage());
            }
            case 8: {
                return new TX(this.getMessage());
            }
            case 9: {
                return new CQ(this.getMessage());
            }
            case 10: {
                return new CQ(this.getMessage());
            }
            case 11: {
                return new TX(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(27));
            }
            case 13: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

