/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.util.SocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class StandardSocketFactory
implements SocketFactory {
    public static final int DEFAULT_ACCEPTED_SOCKET_TIMEOUT = 500;
    private int myAcceptedSocketTimeout = 500;

    public int getAcceptedSocketTimeout() {
        return this.myAcceptedSocketTimeout;
    }

    public void setAcceptedSocketTimeout(int theAcceptedSocketTimeout) {
        if (theAcceptedSocketTimeout < 0) {
            throw new IllegalArgumentException("Timeout can't be negative");
        }
        this.myAcceptedSocketTimeout = theAcceptedSocketTimeout;
    }

    public Socket createSocket() throws IOException {
        Socket retVal = javax.net.SocketFactory.getDefault().createSocket();
        retVal.setKeepAlive(true);
        retVal.setTcpNoDelay(true);
        return retVal;
    }

    public Socket createTlsSocket() throws IOException {
        Socket retVal = SSLSocketFactory.getDefault().createSocket();
        retVal.setKeepAlive(true);
        retVal.setTcpNoDelay(true);
        return retVal;
    }

    public ServerSocket createServerSocket() throws IOException {
        return ServerSocketFactory.getDefault().createServerSocket();
    }

    public ServerSocket createTlsServerSocket() throws IOException {
        return SSLServerSocketFactory.getDefault().createServerSocket();
    }

    public void configureNewAcceptedSocket(Socket theSocket) throws SocketException {
        theSocket.setSoTimeout(this.myAcceptedSocketTimeout);
    }
}

