/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import java.util.Stack;

public class Location {
    private Stack<GroupLocation> groups = new Stack();
    private String segmentName = null;
    private int segmentRepetition = 0;
    private int field = -1;
    private int fieldRepetition = 0;
    private int component = -1;
    private int subcomponent = -1;
    private boolean componentLevel;
    public static final Location UNKNOWN = new Location();

    public Location() {
    }

    public Location(Location l) {
        this.groups = new Stack();
        this.groups.addAll(l.groups);
        this.segmentName = l.segmentName;
        this.segmentRepetition = l.segmentRepetition;
        this.field = l.field;
        this.fieldRepetition = l.fieldRepetition;
        this.component = l.component;
        this.subcomponent = l.subcomponent;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public Location pushGroup(String name, int rep) {
        this.groups.push(new GroupLocation(name, rep));
        return this;
    }

    public void popGroup() {
        this.groups.pop();
    }

    public GroupLocation getGroupLocation() {
        return this.groups.peek();
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public Location withSegmentName(String segmentName) {
        this.segmentName = segmentName;
        return this;
    }

    public boolean isComponentLevel() {
        return this.componentLevel;
    }

    public Location atComponentLevel(boolean componentLevel) {
        this.componentLevel = componentLevel;
        return this;
    }

    public int getSegmentRepetition() {
        return this.segmentRepetition;
    }

    public Location withSegmentRepetition(int segmentRepetition) {
        this.segmentRepetition = segmentRepetition;
        return this;
    }

    public int getField() {
        return this.field;
    }

    public Location withField(int field) {
        this.field = field;
        return this;
    }

    public int getFieldRepetition() {
        return this.fieldRepetition;
    }

    public Location withFieldRepetition(int fieldRepetition) {
        this.fieldRepetition = fieldRepetition;
        return this;
    }

    public int getComponent() {
        return this.component;
    }

    public Location withComponent(int component) {
        this.component = component;
        return this;
    }

    public int getSubcomponent() {
        return this.subcomponent;
    }

    public Location withSubcomponent(int subcomponent) {
        this.subcomponent = subcomponent;
        return this;
    }

    public Location withFieldIndizes(int[] indices) {
        this.field = indices[0];
        this.fieldRepetition = indices[1];
        this.component = indices[2];
        this.subcomponent = indices[3];
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.groups.isEmpty()) {
            sb.append('/');
            for (GroupLocation gl : this.groups) {
                sb.append(gl.groupName);
                if (gl.repetition >= 0) {
                    sb.append('(').append(gl.repetition).append(")");
                }
                sb.append("/");
            }
        }
        if (this.segmentName != null) {
            sb.append(this.segmentName);
            if (this.segmentRepetition > 0) {
                sb.append("(").append(this.segmentRepetition).append(")");
            }
            if (this.field > 0) {
                sb.append("-").append(this.field);
                if (this.fieldRepetition >= 0) {
                    sb.append("(").append(this.fieldRepetition).append(")");
                }
                if (this.component > 0) {
                    sb.append("-").append(this.component);
                    if (this.subcomponent > 0) {
                        sb.append("-").append(this.subcomponent);
                    }
                }
            }
        } else if (sb.length() == 0) {
            sb.append("unknown location");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + this.component;
        result = 31 * result + this.field;
        result = 31 * result + this.fieldRepetition;
        result = 31 * result + (this.segmentName == null ? 0 : this.segmentName.hashCode());
        result = 31 * result + this.segmentRepetition;
        result = 31 * result + this.subcomponent;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.component != other.component) {
            return false;
        }
        if (this.field != other.field) {
            return false;
        }
        if (this.fieldRepetition != other.fieldRepetition) {
            return false;
        }
        if (this.segmentName == null ? other.segmentName != null : !this.segmentName.equals(other.segmentName)) {
            return false;
        }
        if (this.segmentRepetition != other.segmentRepetition) {
            return false;
        }
        return this.subcomponent == other.subcomponent;
    }

    private static class GroupLocation {
        String groupName;
        int repetition;

        private GroupLocation(String groupName, int repetition) {
            this.groupName = groupName;
            this.repetition = repetition;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public int getRepetition() {
            return this.repetition;
        }
    }
}

