/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

public enum Severity {
    INFO("I", "Info"),
    WARNING("W", "Warning"),
    ERROR("E", "Error");

    private static final String HL70516 = "HL70516";
    private final String code;
    private final String message;

    private Severity(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static Severity severityFor(String code) {
        for (Severity severity : Severity.values()) {
            if (!severity.code.equals(code)) continue;
            return severity;
        }
        return null;
    }

    public static String codeTable() {
        return HL70516;
    }
}

