/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LowerLayerProtocol {
    private static final Logger log = LoggerFactory.getLogger(LowerLayerProtocol.class);
    protected Charset charset;

    public static LowerLayerProtocol makeLLP() {
        return new MinLowerLayerProtocol();
    }

    public static LowerLayerProtocol makeLLP(boolean respectMSH18) {
        return new MinLowerLayerProtocol(respectMSH18);
    }

    public abstract HL7Reader getReader(InputStream var1) throws LLPException;

    public abstract HL7Writer getWriter(OutputStream var1) throws LLPException;

    public static void logCharacterReceived(int c) {
        log.trace("Char received: {} ({})", (Object)c, (Object)Character.valueOf((char)c));
    }

    public void setCharset(Charset theCharset) {
        this.charset = theCharset;
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }
}

