/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_BATCH_TOTAL;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BTS
extends AbstractSegment {
    public BTS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Batch Message Count");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Batch Comment");
            this.add(CM_BATCH_TOTAL.class, false, 0, 100, new Object[]{this.getMessage()}, "Batch Totals");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BTS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getBatchMessageCount() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getBts1_BatchMessageCount() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getBatchComment() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getBts2_BatchComment() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_BATCH_TOTAL[] getBatchTotals() {
        CM_BATCH_TOTAL[] retVal = (CM_BATCH_TOTAL[])this.getTypedField(3, new CM_BATCH_TOTAL[0]);
        return retVal;
    }

    public CM_BATCH_TOTAL[] getBts3_BatchTotals() {
        CM_BATCH_TOTAL[] retVal = (CM_BATCH_TOTAL[])this.getTypedField(3, new CM_BATCH_TOTAL[0]);
        return retVal;
    }

    public int getBatchTotalsReps() {
        return this.getReps(3);
    }

    public CM_BATCH_TOTAL getBatchTotals(int rep) {
        CM_BATCH_TOTAL retVal = (CM_BATCH_TOTAL)this.getTypedField(3, rep);
        return retVal;
    }

    public CM_BATCH_TOTAL getBts3_BatchTotals(int rep) {
        CM_BATCH_TOTAL retVal = (CM_BATCH_TOTAL)this.getTypedField(3, rep);
        return retVal;
    }

    public int getBts3_BatchTotalsReps() {
        return this.getReps(3);
    }

    public CM_BATCH_TOTAL insertBatchTotals(int rep) throws HL7Exception {
        return (CM_BATCH_TOTAL)super.insertRepetition(3, rep);
    }

    public CM_BATCH_TOTAL insertBts3_BatchTotals(int rep) throws HL7Exception {
        return (CM_BATCH_TOTAL)super.insertRepetition(3, rep);
    }

    public CM_BATCH_TOTAL removeBatchTotals(int rep) throws HL7Exception {
        return (CM_BATCH_TOTAL)super.removeRepetition(3, rep);
    }

    public CM_BATCH_TOTAL removeBts3_BatchTotals(int rep) throws HL7Exception {
        return (CM_BATCH_TOTAL)super.removeRepetition(3, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CM_BATCH_TOTAL(this.getMessage());
            }
        }
        return null;
    }
}

