/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_ABS_RANGE;
import ca.uhn.hl7v2.model.v22.datatype.CM_DLT;
import ca.uhn.hl7v2.model.v22.datatype.CM_RANGE;
import ca.uhn.hl7v2.model.v22.datatype.CM_RFR;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM2
extends AbstractSegment {
    public OM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Segment Type ID");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Units of Measure");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Range of Decimal Precision");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Corresponding SI Units of Measure");
            this.add(TX.class, true, 0, 20, new Object[]{this.getMessage()}, "SI Conversion Factor");
            this.add(CM_RFR.class, false, 0, 200, new Object[]{this.getMessage()}, "Reference (normal) range - ordinal & continuous observations");
            this.add(CM_RANGE.class, false, 1, 200, new Object[]{this.getMessage()}, "Critical range for ordinal and continuous observations");
            this.add(CM_ABS_RANGE.class, false, 1, 200, new Object[]{this.getMessage()}, "Absolute range for ordinal and continuous observations");
            this.add(CM_DLT.class, false, 0, 200, new Object[]{this.getMessage()}, "Delta Check Criteria");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Meaningful Increments");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getSegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOm21_SegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOm22_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getOm23_UnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRangeOfDecimalPrecision() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getOm24_RangeOfDecimalPrecision() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getCorrespondingSIUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getOm25_CorrespondingSIUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public TX[] getSIConversionFactor() {
        TX[] retVal = (TX[])this.getTypedField(6, new TX[0]);
        return retVal;
    }

    public TX[] getOm26_SIConversionFactor() {
        TX[] retVal = (TX[])this.getTypedField(6, new TX[0]);
        return retVal;
    }

    public int getSIConversionFactorReps() {
        return this.getReps(6);
    }

    public TX getSIConversionFactor(int rep) {
        TX retVal = (TX)this.getTypedField(6, rep);
        return retVal;
    }

    public TX getOm26_SIConversionFactor(int rep) {
        TX retVal = (TX)this.getTypedField(6, rep);
        return retVal;
    }

    public int getOm26_SIConversionFactorReps() {
        return this.getReps(6);
    }

    public TX insertSIConversionFactor(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(6, rep);
    }

    public TX insertOm26_SIConversionFactor(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(6, rep);
    }

    public TX removeSIConversionFactor(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(6, rep);
    }

    public TX removeOm26_SIConversionFactor(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(6, rep);
    }

    public CM_RFR[] getReferenceNormalRangeOrdinalContinuousObservations() {
        CM_RFR[] retVal = (CM_RFR[])this.getTypedField(7, new CM_RFR[0]);
        return retVal;
    }

    public CM_RFR[] getOm27_ReferenceNormalRangeOrdinalContinuousObservations() {
        CM_RFR[] retVal = (CM_RFR[])this.getTypedField(7, new CM_RFR[0]);
        return retVal;
    }

    public int getReferenceNormalRangeOrdinalContinuousObservationsReps() {
        return this.getReps(7);
    }

    public CM_RFR getReferenceNormalRangeOrdinalContinuousObservations(int rep) {
        CM_RFR retVal = (CM_RFR)this.getTypedField(7, rep);
        return retVal;
    }

    public CM_RFR getOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) {
        CM_RFR retVal = (CM_RFR)this.getTypedField(7, rep);
        return retVal;
    }

    public int getOm27_ReferenceNormalRangeOrdinalContinuousObservationsReps() {
        return this.getReps(7);
    }

    public CM_RFR insertReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception {
        return (CM_RFR)super.insertRepetition(7, rep);
    }

    public CM_RFR insertOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception {
        return (CM_RFR)super.insertRepetition(7, rep);
    }

    public CM_RFR removeReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception {
        return (CM_RFR)super.removeRepetition(7, rep);
    }

    public CM_RFR removeOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception {
        return (CM_RFR)super.removeRepetition(7, rep);
    }

    public CM_RANGE getCriticalRangeForOrdinalAndContinuousObservations() {
        CM_RANGE retVal = (CM_RANGE)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_RANGE getOm28_CriticalRangeForOrdinalAndContinuousObservations() {
        CM_RANGE retVal = (CM_RANGE)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_ABS_RANGE getAbsoluteRangeForOrdinalAndContinuousObservations() {
        CM_ABS_RANGE retVal = (CM_ABS_RANGE)this.getTypedField(9, 0);
        return retVal;
    }

    public CM_ABS_RANGE getOm29_AbsoluteRangeForOrdinalAndContinuousObservations() {
        CM_ABS_RANGE retVal = (CM_ABS_RANGE)this.getTypedField(9, 0);
        return retVal;
    }

    public CM_DLT[] getDeltaCheckCriteria() {
        CM_DLT[] retVal = (CM_DLT[])this.getTypedField(10, new CM_DLT[0]);
        return retVal;
    }

    public CM_DLT[] getOm210_DeltaCheckCriteria() {
        CM_DLT[] retVal = (CM_DLT[])this.getTypedField(10, new CM_DLT[0]);
        return retVal;
    }

    public int getDeltaCheckCriteriaReps() {
        return this.getReps(10);
    }

    public CM_DLT getDeltaCheckCriteria(int rep) {
        CM_DLT retVal = (CM_DLT)this.getTypedField(10, rep);
        return retVal;
    }

    public CM_DLT getOm210_DeltaCheckCriteria(int rep) {
        CM_DLT retVal = (CM_DLT)this.getTypedField(10, rep);
        return retVal;
    }

    public int getOm210_DeltaCheckCriteriaReps() {
        return this.getReps(10);
    }

    public CM_DLT insertDeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.insertRepetition(10, rep);
    }

    public CM_DLT insertOm210_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.insertRepetition(10, rep);
    }

    public CM_DLT removeDeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.removeRepetition(10, rep);
    }

    public CM_DLT removeOm210_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.removeRepetition(10, rep);
    }

    public NM getMinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getOm211_MinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new TX(this.getMessage());
            }
            case 6: {
                return new CM_RFR(this.getMessage());
            }
            case 7: {
                return new CM_RANGE(this.getMessage());
            }
            case 8: {
                return new CM_ABS_RANGE(this.getMessage());
            }
            case 9: {
                return new CM_DLT(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

