/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.PRR_PC5_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.QRD;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PRR_PC5
extends AbstractMessage {
    public PRR_PC5() {
        this(new DefaultModelClassFactory());
    }

    public PRR_PC5(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QRD.class, true, false);
            this.add(PRR_PC5_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRR_PC5 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public PRR_PC5_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", PRR_PC5_PATIENT.class);
    }

    public PRR_PC5_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, PRR_PC5_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<PRR_PC5_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", PRR_PC5_PATIENT.class);
    }

    public void insertPATIENT(PRR_PC5_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public PRR_PC5_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (PRR_PC5_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public PRR_PC5_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (PRR_PC5_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

