/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.RDE_O01_ORDER;
import ca.uhn.hl7v2.model.v23.group.RDE_O01_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDE_O01
extends AbstractMessage {
    public RDE_O01() {
        this(new DefaultModelClassFactory());
    }

    public RDE_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RDE_O01_PATIENT.class, false, false);
            this.add(RDE_O01_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDE_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RDE_O01_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", RDE_O01_PATIENT.class);
    }

    public RDE_O01_ORDER getORDER() {
        return this.getTyped("ORDER", RDE_O01_ORDER.class);
    }

    public RDE_O01_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, RDE_O01_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RDE_O01_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RDE_O01_ORDER.class);
    }

    public void insertORDER(RDE_O01_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RDE_O01_ORDER insertORDER(int rep) throws HL7Exception {
        return (RDE_O01_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RDE_O01_ORDER removeORDER(int rep) throws HL7Exception {
        return (RDE_O01_ORDER)super.removeRepetition("ORDER", rep);
    }
}

