/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSR
extends AbstractSegment {
    public CSR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Sponsor Study ID");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Alternate Study ID");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Institution Registering the Patient");
            this.add(CX.class, true, 1, 30, new Object[]{this.getMessage()}, "Sponsor Patient ID");
            this.add(CX.class, false, 1, 30, new Object[]{this.getMessage()}, "Alternate Patient ID");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of Patient Study Registration");
            this.add(XCN.class, false, 1, 60, new Object[]{this.getMessage()}, "Person Performing Study Registration");
            this.add(XCN.class, true, 1, 60, new Object[]{this.getMessage()}, "Study Authorizing Provider");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/time Patient Study Consent Signed");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Patient Study Eligibility Status");
            this.add(TS.class, false, 3, 26, new Object[]{this.getMessage()}, "Study Randomization Date/time");
            this.add(CE.class, false, 3, 200, new Object[]{this.getMessage()}, "Study Randomized Arm");
            this.add(CE.class, false, 3, 200, new Object[]{this.getMessage()}, "Stratum for Study Randomization");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Patient Evaluability Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/time Ended Study");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Reason Ended Study");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getSponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getCsr1_SponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getAlternateStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getCsr2_AlternateStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getInstitutionRegisteringThePatient() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getCsr3_InstitutionRegisteringThePatient() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getSponsorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getCsr4_SponsorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getAlternatePatientID() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getCsr5_AlternatePatientID() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDateTimeOfPatientStudyRegistration() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getCsr6_DateTimeOfPatientStudyRegistration() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN getPersonPerformingStudyRegistration() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getCsr7_PersonPerformingStudyRegistration() {
        XCN retVal = (XCN)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getStudyAuthorizingProvider() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public XCN getCsr8_StudyAuthorizingProvider() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getDateTimePatientStudyConsentSigned() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getCsr9_DateTimePatientStudyConsentSigned() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getPatientStudyEligibilityStatus() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getCsr10_PatientStudyEligibilityStatus() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public TS[] getStudyRandomizationDateTime() {
        TS[] retVal = (TS[])this.getTypedField(11, new TS[0]);
        return retVal;
    }

    public TS[] getCsr11_StudyRandomizationDateTime() {
        TS[] retVal = (TS[])this.getTypedField(11, new TS[0]);
        return retVal;
    }

    public int getStudyRandomizationDateTimeReps() {
        return this.getReps(11);
    }

    public TS getStudyRandomizationDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(11, rep);
        return retVal;
    }

    public TS getCsr11_StudyRandomizationDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(11, rep);
        return retVal;
    }

    public int getCsr11_StudyRandomizationDateTimeReps() {
        return this.getReps(11);
    }

    public TS insertStudyRandomizationDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(11, rep);
    }

    public TS insertCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(11, rep);
    }

    public TS removeStudyRandomizationDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(11, rep);
    }

    public TS removeCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(11, rep);
    }

    public CE[] getStudyRandomizedArm() {
        CE[] retVal = (CE[])this.getTypedField(12, new CE[0]);
        return retVal;
    }

    public CE[] getCsr12_StudyRandomizedArm() {
        CE[] retVal = (CE[])this.getTypedField(12, new CE[0]);
        return retVal;
    }

    public int getStudyRandomizedArmReps() {
        return this.getReps(12);
    }

    public CE getStudyRandomizedArm(int rep) {
        CE retVal = (CE)this.getTypedField(12, rep);
        return retVal;
    }

    public CE getCsr12_StudyRandomizedArm(int rep) {
        CE retVal = (CE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getCsr12_StudyRandomizedArmReps() {
        return this.getReps(12);
    }

    public CE insertStudyRandomizedArm(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(12, rep);
    }

    public CE insertCsr12_StudyRandomizedArm(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(12, rep);
    }

    public CE removeStudyRandomizedArm(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(12, rep);
    }

    public CE removeCsr12_StudyRandomizedArm(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(12, rep);
    }

    public CE[] getStratumForStudyRandomization() {
        CE[] retVal = (CE[])this.getTypedField(13, new CE[0]);
        return retVal;
    }

    public CE[] getCsr13_StratumForStudyRandomization() {
        CE[] retVal = (CE[])this.getTypedField(13, new CE[0]);
        return retVal;
    }

    public int getStratumForStudyRandomizationReps() {
        return this.getReps(13);
    }

    public CE getStratumForStudyRandomization(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public CE getCsr13_StratumForStudyRandomization(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getCsr13_StratumForStudyRandomizationReps() {
        return this.getReps(13);
    }

    public CE insertStratumForStudyRandomization(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE insertCsr13_StratumForStudyRandomization(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE removeStratumForStudyRandomization(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public CE removeCsr13_StratumForStudyRandomization(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public CE getPatientEvaluabilityStatus() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getCsr14_PatientEvaluabilityStatus() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getDateTimeEndedStudy() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getCsr15_DateTimeEndedStudy() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getReasonEndedStudy() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getCsr16_ReasonEndedStudy() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new TS(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new TS(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

