/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.ADT_A45_MRGPV1;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A45
extends AbstractMessage {
    public ADT_A45() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A45(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ADT_A45_MRGPV1.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A45 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public ADT_A45_MRGPV1 getMRGPV1() {
        return this.getTyped("MRGPV1", ADT_A45_MRGPV1.class);
    }

    public ADT_A45_MRGPV1 getMRGPV1(int rep) {
        return this.getTyped("MRGPV1", rep, ADT_A45_MRGPV1.class);
    }

    public int getMRGPV1Reps() {
        return this.getReps("MRGPV1");
    }

    public List<ADT_A45_MRGPV1> getMRGPV1All() throws HL7Exception {
        return this.getAllAsList("MRGPV1", ADT_A45_MRGPV1.class);
    }

    public void insertMRGPV1(ADT_A45_MRGPV1 structure, int rep) throws HL7Exception {
        super.insertRepetition("MRGPV1", structure, rep);
    }

    public ADT_A45_MRGPV1 insertMRGPV1(int rep) throws HL7Exception {
        return (ADT_A45_MRGPV1)super.insertRepetition("MRGPV1", rep);
    }

    public ADT_A45_MRGPV1 removeMRGPV1(int rep) throws HL7Exception {
        return (ADT_A45_MRGPV1)super.removeRepetition("MRGPV1", rep);
    }
}

