/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.PPT_PCL_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPT_PCL
extends AbstractMessage {
    public PPT_PCL() {
        this(new DefaultModelClassFactory());
    }

    public PPT_PCL(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(PPT_PCL_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPT_PCL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public PPT_PCL_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", PPT_PCL_PATIENT.class);
    }

    public PPT_PCL_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, PPT_PCL_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<PPT_PCL_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", PPT_PCL_PATIENT.class);
    }

    public void insertPATIENT(PPT_PCL_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public PPT_PCL_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (PPT_PCL_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public PPT_PCL_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (PPT_PCL_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

