/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.FT;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NTE
extends AbstractSegment {
    public NTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - NTE");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(105)}, "Source of Comment");
            this.add(FT.class, false, 0, 65536, new Object[]{this.getMessage()}, "Comment");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Comment Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NTE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDNTE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNte1_SetIDNTE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSourceOfComment() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getNte2_SourceOfComment() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public FT[] getComment() {
        FT[] retVal = (FT[])this.getTypedField(3, new FT[0]);
        return retVal;
    }

    public FT[] getNte3_Comment() {
        FT[] retVal = (FT[])this.getTypedField(3, new FT[0]);
        return retVal;
    }

    public int getCommentReps() {
        return this.getReps(3);
    }

    public FT getComment(int rep) {
        FT retVal = (FT)this.getTypedField(3, rep);
        return retVal;
    }

    public FT getNte3_Comment(int rep) {
        FT retVal = (FT)this.getTypedField(3, rep);
        return retVal;
    }

    public int getNte3_CommentReps() {
        return this.getReps(3);
    }

    public FT insertComment(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(3, rep);
    }

    public FT insertNte3_Comment(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(3, rep);
    }

    public FT removeComment(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(3, rep);
    }

    public FT removeNte3_Comment(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(3, rep);
    }

    public CE getCommentType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getNte4_CommentType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(105));
            }
            case 2: {
                return new FT(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

