/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.DLD;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.FC;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV1
extends AbstractSegment {
    public PV1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - PV1");
            this.add(IS.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(4)}, "Patient Class");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(7)}, "Admission Type");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Preadmit Number");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Prior Patient Location");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Attending Doctor");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Referring Doctor");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Consulting Doctor");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(69)}, "Hospital Service");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Temporary Location");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(87)}, "Preadmit Test Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(92)}, "Re-admission Indicator");
            this.add(IS.class, false, 1, 6, new Object[]{this.getMessage(), new Integer(23)}, "Admit Source");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP Indicator");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Admitting Doctor");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient Type");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Visit Number");
            this.add(FC.class, false, 0, 50, new Object[]{this.getMessage()}, "Financial Class");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(32)}, "Charge Price Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(45)}, "Courtesy Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(46)}, "Credit Rating");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(44)}, "Contract Code");
            this.add(DT.class, false, 0, 8, new Object[]{this.getMessage()}, "Contract Effective Date");
            this.add(NM.class, false, 0, 12, new Object[]{this.getMessage()}, "Contract Amount");
            this.add(NM.class, false, 0, 3, new Object[]{this.getMessage()}, "Contract Period");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(73)}, "Interest Code");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(110)}, "Transfer to Bad Debt Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Transfer to Bad Debt Date");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(21)}, "Bad Debt Agency Code");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Transfer Amount");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Recovery Amount");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(111)}, "Delete Account Indicator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Delete Account Date");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(112)}, "Discharge Disposition");
            this.add(DLD.class, false, 1, 47, new Object[]{this.getMessage()}, "Discharged to Location");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Diet Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(115)}, "Servicing Facility");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(116)}, "Bed Status");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(117)}, "Account Status");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Pending Location");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Prior Temporary Location");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Admit Date/Time");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Discharge Date/Time");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Current Patient Balance");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Charges");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Adjustments");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Payments");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Alternate Visit ID");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(326)}, "Visit Indicator");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Other Healthcare Provider");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPV1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPv11_SetIDPV1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getPatientClass() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getPv12_PatientClass() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public PL getAssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(3, 0);
        return retVal;
    }

    public PL getPv13_AssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getAdmissionType() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getPv14_AdmissionType() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPreadmitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getPv15_PreadmitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public PL getPriorPatientLocation() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    public PL getPv16_PriorPatientLocation() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN[] getAttendingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(7, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv17_AttendingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(7, new XCN[0]);
        return retVal;
    }

    public int getAttendingDoctorReps() {
        return this.getReps(7);
    }

    public XCN getAttendingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public XCN getPv17_AttendingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPv17_AttendingDoctorReps() {
        return this.getReps(7);
    }

    public XCN insertAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN insertPv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN removeAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN removePv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN[] getReferringDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv18_ReferringDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public int getReferringDoctorReps() {
        return this.getReps(8);
    }

    public XCN getReferringDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getPv18_ReferringDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPv18_ReferringDoctorReps() {
        return this.getReps(8);
    }

    public XCN insertReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertPv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removePv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN[] getConsultingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv19_ConsultingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public int getConsultingDoctorReps() {
        return this.getReps(9);
    }

    public XCN getConsultingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public XCN getPv19_ConsultingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPv19_ConsultingDoctorReps() {
        return this.getReps(9);
    }

    public XCN insertConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertPv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removePv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public IS getHospitalService() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getPv110_HospitalService() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public PL getTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public PL getPv111_TemporaryLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getPreadmitTestIndicator() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getPv112_PreadmitTestIndicator() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getReAdmissionIndicator() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public IS getPv113_ReAdmissionIndicator() {
        IS retVal = (IS)this.getTypedField(13, 0);
        return retVal;
    }

    public IS getAdmitSource() {
        IS retVal = (IS)this.getTypedField(14, 0);
        return retVal;
    }

    public IS getPv114_AdmitSource() {
        IS retVal = (IS)this.getTypedField(14, 0);
        return retVal;
    }

    public IS[] getAmbulatoryStatus() {
        IS[] retVal = (IS[])this.getTypedField(15, new IS[0]);
        return retVal;
    }

    public IS[] getPv115_AmbulatoryStatus() {
        IS[] retVal = (IS[])this.getTypedField(15, new IS[0]);
        return retVal;
    }

    public int getAmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public IS getAmbulatoryStatus(int rep) {
        IS retVal = (IS)this.getTypedField(15, rep);
        return retVal;
    }

    public IS getPv115_AmbulatoryStatus(int rep) {
        IS retVal = (IS)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPv115_AmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public IS insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(15, rep);
    }

    public IS insertPv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(15, rep);
    }

    public IS removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(15, rep);
    }

    public IS removePv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(15, rep);
    }

    public IS getVIPIndicator() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getPv116_VIPIndicator() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public XCN[] getAdmittingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(17, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv117_AdmittingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(17, new XCN[0]);
        return retVal;
    }

    public int getAdmittingDoctorReps() {
        return this.getReps(17);
    }

    public XCN getAdmittingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(17, rep);
        return retVal;
    }

    public XCN getPv117_AdmittingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getPv117_AdmittingDoctorReps() {
        return this.getReps(17);
    }

    public XCN insertAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN insertPv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN removeAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public XCN removePv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public IS getPatientType() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getPv118_PatientType() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public CX getVisitNumber() {
        CX retVal = (CX)this.getTypedField(19, 0);
        return retVal;
    }

    public CX getPv119_VisitNumber() {
        CX retVal = (CX)this.getTypedField(19, 0);
        return retVal;
    }

    public FC[] getFinancialClass() {
        FC[] retVal = (FC[])this.getTypedField(20, new FC[0]);
        return retVal;
    }

    public FC[] getPv120_FinancialClass() {
        FC[] retVal = (FC[])this.getTypedField(20, new FC[0]);
        return retVal;
    }

    public int getFinancialClassReps() {
        return this.getReps(20);
    }

    public FC getFinancialClass(int rep) {
        FC retVal = (FC)this.getTypedField(20, rep);
        return retVal;
    }

    public FC getPv120_FinancialClass(int rep) {
        FC retVal = (FC)this.getTypedField(20, rep);
        return retVal;
    }

    public int getPv120_FinancialClassReps() {
        return this.getReps(20);
    }

    public FC insertFinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC insertPv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC removeFinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public FC removePv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public IS getChargePriceIndicator() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getPv121_ChargePriceIndicator() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getCourtesyCode() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getPv122_CourtesyCode() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getCreditRating() {
        IS retVal = (IS)this.getTypedField(23, 0);
        return retVal;
    }

    public IS getPv123_CreditRating() {
        IS retVal = (IS)this.getTypedField(23, 0);
        return retVal;
    }

    public IS[] getContractCode() {
        IS[] retVal = (IS[])this.getTypedField(24, new IS[0]);
        return retVal;
    }

    public IS[] getPv124_ContractCode() {
        IS[] retVal = (IS[])this.getTypedField(24, new IS[0]);
        return retVal;
    }

    public int getContractCodeReps() {
        return this.getReps(24);
    }

    public IS getContractCode(int rep) {
        IS retVal = (IS)this.getTypedField(24, rep);
        return retVal;
    }

    public IS getPv124_ContractCode(int rep) {
        IS retVal = (IS)this.getTypedField(24, rep);
        return retVal;
    }

    public int getPv124_ContractCodeReps() {
        return this.getReps(24);
    }

    public IS insertContractCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS insertPv124_ContractCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS removeContractCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public IS removePv124_ContractCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public DT[] getContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public DT[] getPv125_ContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public int getContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT getContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public DT getPv125_ContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public int getPv125_ContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT insertContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT insertPv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT removeContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public DT removePv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public NM[] getContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public NM[] getPv126_ContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public int getContractAmountReps() {
        return this.getReps(26);
    }

    public NM getContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public NM getPv126_ContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPv126_ContractAmountReps() {
        return this.getReps(26);
    }

    public NM insertContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM insertPv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM removeContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM removePv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM[] getContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public NM[] getPv127_ContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public int getContractPeriodReps() {
        return this.getReps(27);
    }

    public NM getContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public NM getPv127_ContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public int getPv127_ContractPeriodReps() {
        return this.getReps(27);
    }

    public NM insertContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM insertPv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM removeContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public NM removePv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public IS getInterestCode() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public IS getPv128_InterestCode() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public IS getTransferToBadDebtCode() {
        IS retVal = (IS)this.getTypedField(29, 0);
        return retVal;
    }

    public IS getPv129_TransferToBadDebtCode() {
        IS retVal = (IS)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getTransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getPv130_TransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public IS getBadDebtAgencyCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getPv131_BadDebtAgencyCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public NM getBadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getPv132_BadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getBadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getPv133_BadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public IS getDeleteAccountIndicator() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getPv134_DeleteAccountIndicator() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public DT getDeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public DT getPv135_DeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getDischargeDisposition() {
        IS retVal = (IS)this.getTypedField(36, 0);
        return retVal;
    }

    public IS getPv136_DischargeDisposition() {
        IS retVal = (IS)this.getTypedField(36, 0);
        return retVal;
    }

    public DLD getDischargedToLocation() {
        DLD retVal = (DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public DLD getPv137_DischargedToLocation() {
        DLD retVal = (DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public CE getDietType() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getPv138_DietType() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public IS getServicingFacility() {
        IS retVal = (IS)this.getTypedField(39, 0);
        return retVal;
    }

    public IS getPv139_ServicingFacility() {
        IS retVal = (IS)this.getTypedField(39, 0);
        return retVal;
    }

    public IS getBedStatus() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public IS getPv140_BedStatus() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public IS getAccountStatus() {
        IS retVal = (IS)this.getTypedField(41, 0);
        return retVal;
    }

    public IS getPv141_AccountStatus() {
        IS retVal = (IS)this.getTypedField(41, 0);
        return retVal;
    }

    public PL getPendingLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public PL getPv142_PendingLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public PL getPriorTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(43, 0);
        return retVal;
    }

    public PL getPv143_PriorTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(43, 0);
        return retVal;
    }

    public TS getAdmitDateTime() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS getPv144_AdmitDateTime() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS[] getDischargeDateTime() {
        TS[] retVal = (TS[])this.getTypedField(45, new TS[0]);
        return retVal;
    }

    public TS[] getPv145_DischargeDateTime() {
        TS[] retVal = (TS[])this.getTypedField(45, new TS[0]);
        return retVal;
    }

    public int getDischargeDateTimeReps() {
        return this.getReps(45);
    }

    public TS getDischargeDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(45, rep);
        return retVal;
    }

    public TS getPv145_DischargeDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(45, rep);
        return retVal;
    }

    public int getPv145_DischargeDateTimeReps() {
        return this.getReps(45);
    }

    public TS insertDischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(45, rep);
    }

    public TS insertPv145_DischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(45, rep);
    }

    public TS removeDischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(45, rep);
    }

    public TS removePv145_DischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(45, rep);
    }

    public NM getCurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getPv146_CurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getTotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getPv147_TotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getTotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getPv148_TotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getTotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public NM getPv149_TotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public CX getAlternateVisitID() {
        CX retVal = (CX)this.getTypedField(50, 0);
        return retVal;
    }

    public CX getPv150_AlternateVisitID() {
        CX retVal = (CX)this.getTypedField(50, 0);
        return retVal;
    }

    public IS getVisitIndicator() {
        IS retVal = (IS)this.getTypedField(51, 0);
        return retVal;
    }

    public IS getPv151_VisitIndicator() {
        IS retVal = (IS)this.getTypedField(51, 0);
        return retVal;
    }

    public XCN[] getOtherHealthcareProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(52, new XCN[0]);
        return retVal;
    }

    public XCN[] getPv152_OtherHealthcareProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(52, new XCN[0]);
        return retVal;
    }

    public int getOtherHealthcareProviderReps() {
        return this.getReps(52);
    }

    public XCN getOtherHealthcareProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(52, rep);
        return retVal;
    }

    public XCN getPv152_OtherHealthcareProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(52, rep);
        return retVal;
    }

    public int getPv152_OtherHealthcareProviderReps() {
        return this.getReps(52);
    }

    public XCN insertOtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(52, rep);
    }

    public XCN insertPv152_OtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(52, rep);
    }

    public XCN removeOtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(52, rep);
    }

    public XCN removePv152_OtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(52, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(4));
            }
            case 2: {
                return new PL(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(7));
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new PL(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(69));
            }
            case 10: {
                return new PL(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(87));
            }
            case 12: {
                return new IS(this.getMessage(), new Integer(92));
            }
            case 13: {
                return new IS(this.getMessage(), new Integer(23));
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(99));
            }
            case 16: {
                return new XCN(this.getMessage());
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new FC(this.getMessage());
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(32));
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(45));
            }
            case 22: {
                return new IS(this.getMessage(), new Integer(46));
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(44));
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new IS(this.getMessage(), new Integer(73));
            }
            case 28: {
                return new IS(this.getMessage(), new Integer(110));
            }
            case 29: {
                return new DT(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(21));
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(111));
            }
            case 34: {
                return new DT(this.getMessage());
            }
            case 35: {
                return new IS(this.getMessage(), new Integer(112));
            }
            case 36: {
                return new DLD(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new IS(this.getMessage(), new Integer(115));
            }
            case 39: {
                return new IS(this.getMessage(), new Integer(116));
            }
            case 40: {
                return new IS(this.getMessage(), new Integer(117));
            }
            case 41: {
                return new PL(this.getMessage());
            }
            case 42: {
                return new PL(this.getMessage());
            }
            case 43: {
                return new TS(this.getMessage());
            }
            case 44: {
                return new TS(this.getMessage());
            }
            case 45: {
                return new NM(this.getMessage());
            }
            case 46: {
                return new NM(this.getMessage());
            }
            case 47: {
                return new NM(this.getMessage());
            }
            case 48: {
                return new NM(this.getMessage());
            }
            case 49: {
                return new CX(this.getMessage());
            }
            case 50: {
                return new IS(this.getMessage(), new Integer(326));
            }
            case 51: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

