/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;

public class DTN
extends AbstractComposite {
    private Type[] data;

    public DTN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new IS(this.getMessage(), 149);
        this.data[1] = new NM(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getDayType() {
        return this.getTyped(0, IS.class);
    }

    public IS getDtn1_DayType() {
        return this.getTyped(0, IS.class);
    }

    public NM getNumberOfDays() {
        return this.getTyped(1, NM.class);
    }

    public NM getDtn2_NumberOfDays() {
        return this.getTyped(1, NM.class);
    }
}

