/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;

public class ICD
extends AbstractComposite {
    private Type[] data;

    public ICD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new IS(this.getMessage(), 150);
        this.data[1] = new ID(this.getMessage(), 136);
        this.data[2] = new DTM(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getCertificationPatientType() {
        return this.getTyped(0, IS.class);
    }

    public IS getIcd1_CertificationPatientType() {
        return this.getTyped(0, IS.class);
    }

    public ID getCertificationRequired() {
        return this.getTyped(1, ID.class);
    }

    public ID getIcd2_CertificationRequired() {
        return this.getTyped(1, ID.class);
    }

    public DTM getDateTimeCertificationRequired() {
        return this.getTyped(2, DTM.class);
    }

    public DTM getIcd3_DateTimeCertificationRequired() {
        return this.getTyped(2, DTM.class);
    }
}

