/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E12_REQUEST;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.PSL;
import ca.uhn.hl7v2.model.v26.segment.PSS;
import ca.uhn.hl7v2.model.v26.segment.RFI;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E12
extends AbstractMessage {
    public EHC_E12() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(RFI.class, true, false);
            this.add(CTD.class, false, true);
            this.add(IVC.class, true, false);
            this.add(PSS.class, true, false);
            this.add(PSG.class, true, false);
            this.add(PID.class, false, false);
            this.add(PSL.class, false, true);
            this.add(EHC_E12_REQUEST.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public RFI getRFI() {
        return this.getTyped("RFI", RFI.class);
    }

    public CTD getCTD() {
        return this.getTyped("CTD", CTD.class);
    }

    public CTD getCTD(int rep) {
        return this.getTyped("CTD", rep, CTD.class);
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public IVC getIVC() {
        return this.getTyped("IVC", IVC.class);
    }

    public PSS getPSS() {
        return this.getTyped("PSS", PSS.class);
    }

    public PSG getPSG() {
        return this.getTyped("PSG", PSG.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PSL getPSL() {
        return this.getTyped("PSL", PSL.class);
    }

    public PSL getPSL(int rep) {
        return this.getTyped("PSL", rep, PSL.class);
    }

    public int getPSLReps() {
        return this.getReps("PSL");
    }

    public List<PSL> getPSLAll() throws HL7Exception {
        return this.getAllAsList("PSL", PSL.class);
    }

    public void insertPSL(PSL structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL", structure, rep);
    }

    public PSL insertPSL(int rep) throws HL7Exception {
        return (PSL)super.insertRepetition("PSL", rep);
    }

    public PSL removePSL(int rep) throws HL7Exception {
        return (PSL)super.removeRepetition("PSL", rep);
    }

    public EHC_E12_REQUEST getREQUEST() {
        return this.getTyped("REQUEST", EHC_E12_REQUEST.class);
    }

    public EHC_E12_REQUEST getREQUEST(int rep) {
        return this.getTyped("REQUEST", rep, EHC_E12_REQUEST.class);
    }

    public int getREQUESTReps() {
        return this.getReps("REQUEST");
    }

    public List<EHC_E12_REQUEST> getREQUESTAll() throws HL7Exception {
        return this.getAllAsList("REQUEST", EHC_E12_REQUEST.class);
    }

    public void insertREQUEST(EHC_E12_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("REQUEST", structure, rep);
    }

    public EHC_E12_REQUEST insertREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.insertRepetition("REQUEST", rep);
    }

    public EHC_E12_REQUEST removeREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.removeRepetition("REQUEST", rep);
    }
}

