/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.FC;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.JCC;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GT1
extends AbstractSegment {
    public GT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - GT1");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Number");
            this.add(XPN.class, true, 0, 250, new Object[]{this.getMessage()}, "Guarantor Name");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Spouse Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Address");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Ph Num - Home");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Ph Num - Business");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Guarantor Date/Time Of Birth");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Guarantor Administrative Sex");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(68)}, "Guarantor Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Guarantor Relationship");
            this.add(ST.class, false, 1, 11, new Object[]{this.getMessage()}, "Guarantor SSN");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Date - Begin");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Date - End");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Guarantor Priority");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employer Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employer Address");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employer Phone Number");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employee ID Number");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(66)}, "Guarantor Employment Status");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Organization Name");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Guarantor Billing Hold Flag");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Guarantor Credit Rating Code");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Guarantor Death Date And Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Guarantor Death Flag");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Guarantor Charge Adjustment Code");
            this.add(CP.class, false, 1, 10, new Object[]{this.getMessage()}, "Guarantor Household Annual Income");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Guarantor Household Size");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employer ID Number");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Guarantor Marital Status Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Hire Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Employment Stop Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Citizenship");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(220)}, "Living Arrangement");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Publicity Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(231)}, "Student Indicator");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Religion");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Nationality");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Ethnic Group");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact Person's Name");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact Person's Telephone Number");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Contact Reason");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(63)}, "Contact Relationship");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Code/Class");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Employer's Organization Name");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(295)}, "Handicap");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(311)}, "Job Status");
            this.add(FC.class, false, 1, 50, new Object[]{this.getMessage()}, "Guarantor Financial Class");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Guarantor Race");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Guarantor Birth Place");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDGT1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getGt11_SetIDGT1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX[] getGuarantorNumber() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public CX[] getGt12_GuarantorNumber() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public int getGuarantorNumberReps() {
        return this.getReps(2);
    }

    public CX getGuarantorNumber(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public CX getGt12_GuarantorNumber(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public int getGt12_GuarantorNumberReps() {
        return this.getReps(2);
    }

    public CX insertGuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertGt12_GuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removeGuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removeGt12_GuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public XPN[] getGuarantorName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt13_GuarantorName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, new XPN[0]);
        return retVal;
    }

    public int getGuarantorNameReps() {
        return this.getReps(3);
    }

    public XPN getGuarantorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public XPN getGt13_GuarantorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getGt13_GuarantorNameReps() {
        return this.getReps(3);
    }

    public XPN insertGuarantorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN insertGt13_GuarantorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN removeGuarantorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public XPN removeGt13_GuarantorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public XPN[] getGuarantorSpouseName() {
        XPN[] retVal = (XPN[])this.getTypedField(4, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt14_GuarantorSpouseName() {
        XPN[] retVal = (XPN[])this.getTypedField(4, new XPN[0]);
        return retVal;
    }

    public int getGuarantorSpouseNameReps() {
        return this.getReps(4);
    }

    public XPN getGuarantorSpouseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(4, rep);
        return retVal;
    }

    public XPN getGt14_GuarantorSpouseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getGt14_GuarantorSpouseNameReps() {
        return this.getReps(4);
    }

    public XPN insertGuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(4, rep);
    }

    public XPN insertGt14_GuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(4, rep);
    }

    public XPN removeGuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(4, rep);
    }

    public XPN removeGt14_GuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(4, rep);
    }

    public XAD[] getGuarantorAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, new XAD[0]);
        return retVal;
    }

    public XAD[] getGt15_GuarantorAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, new XAD[0]);
        return retVal;
    }

    public int getGuarantorAddressReps() {
        return this.getReps(5);
    }

    public XAD getGuarantorAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public XAD getGt15_GuarantorAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getGt15_GuarantorAddressReps() {
        return this.getReps(5);
    }

    public XAD insertGuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD insertGt15_GuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD removeGuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XAD removeGt15_GuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XTN[] getGuarantorPhNumHome() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt16_GuarantorPhNumHome() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public int getGuarantorPhNumHomeReps() {
        return this.getReps(6);
    }

    public XTN getGuarantorPhNumHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public XTN getGt16_GuarantorPhNumHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getGt16_GuarantorPhNumHomeReps() {
        return this.getReps(6);
    }

    public XTN insertGuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertGt16_GuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeGuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeGt16_GuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN[] getGuarantorPhNumBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt17_GuarantorPhNumBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public int getGuarantorPhNumBusinessReps() {
        return this.getReps(7);
    }

    public XTN getGuarantorPhNumBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public XTN getGt17_GuarantorPhNumBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getGt17_GuarantorPhNumBusinessReps() {
        return this.getReps(7);
    }

    public XTN insertGuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN insertGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN removeGuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public XTN removeGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public DTM getGuarantorDateTimeOfBirth() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getGt18_GuarantorDateTimeOfBirth() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getGuarantorAdministrativeSex() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getGt19_GuarantorAdministrativeSex() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getGuarantorType() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getGt110_GuarantorType() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getGuarantorRelationship() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getGt111_GuarantorRelationship() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getGuarantorSSN() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getGt112_GuarantorSSN() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getGuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGt113_GuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getGt114_GuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getGuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getGt115_GuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public XPN[] getGuarantorEmployerName() {
        XPN[] retVal = (XPN[])this.getTypedField(16, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt116_GuarantorEmployerName() {
        XPN[] retVal = (XPN[])this.getTypedField(16, new XPN[0]);
        return retVal;
    }

    public int getGuarantorEmployerNameReps() {
        return this.getReps(16);
    }

    public XPN getGuarantorEmployerName(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public XPN getGt116_GuarantorEmployerName(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getGt116_GuarantorEmployerNameReps() {
        return this.getReps(16);
    }

    public XPN insertGuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN insertGt116_GuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN removeGuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XPN removeGt116_GuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XAD[] getGuarantorEmployerAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(17, new XAD[0]);
        return retVal;
    }

    public XAD[] getGt117_GuarantorEmployerAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(17, new XAD[0]);
        return retVal;
    }

    public int getGuarantorEmployerAddressReps() {
        return this.getReps(17);
    }

    public XAD getGuarantorEmployerAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(17, rep);
        return retVal;
    }

    public XAD getGt117_GuarantorEmployerAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(17, rep);
        return retVal;
    }

    public int getGt117_GuarantorEmployerAddressReps() {
        return this.getReps(17);
    }

    public XAD insertGuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(17, rep);
    }

    public XAD insertGt117_GuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(17, rep);
    }

    public XAD removeGuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(17, rep);
    }

    public XAD removeGt117_GuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(17, rep);
    }

    public XTN[] getGuarantorEmployerPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(18, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt118_GuarantorEmployerPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(18, new XTN[0]);
        return retVal;
    }

    public int getGuarantorEmployerPhoneNumberReps() {
        return this.getReps(18);
    }

    public XTN getGuarantorEmployerPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(18, rep);
        return retVal;
    }

    public XTN getGt118_GuarantorEmployerPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(18, rep);
        return retVal;
    }

    public int getGt118_GuarantorEmployerPhoneNumberReps() {
        return this.getReps(18);
    }

    public XTN insertGuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(18, rep);
    }

    public XTN insertGt118_GuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(18, rep);
    }

    public XTN removeGuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(18, rep);
    }

    public XTN removeGt118_GuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(18, rep);
    }

    public CX[] getGuarantorEmployeeIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(19, new CX[0]);
        return retVal;
    }

    public CX[] getGt119_GuarantorEmployeeIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(19, new CX[0]);
        return retVal;
    }

    public int getGuarantorEmployeeIDNumberReps() {
        return this.getReps(19);
    }

    public CX getGuarantorEmployeeIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(19, rep);
        return retVal;
    }

    public CX getGt119_GuarantorEmployeeIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(19, rep);
        return retVal;
    }

    public int getGt119_GuarantorEmployeeIDNumberReps() {
        return this.getReps(19);
    }

    public CX insertGuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(19, rep);
    }

    public CX insertGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(19, rep);
    }

    public CX removeGuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(19, rep);
    }

    public CX removeGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(19, rep);
    }

    public IS getGuarantorEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getGt120_GuarantorEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public XON[] getGuarantorOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public XON[] getGt121_GuarantorOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public int getGuarantorOrganizationNameReps() {
        return this.getReps(21);
    }

    public XON getGuarantorOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public XON getGt121_GuarantorOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public int getGt121_GuarantorOrganizationNameReps() {
        return this.getReps(21);
    }

    public XON insertGuarantorOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON insertGt121_GuarantorOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON removeGuarantorOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public XON removeGt121_GuarantorOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public ID getGuarantorBillingHoldFlag() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getGt122_GuarantorBillingHoldFlag() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getGuarantorCreditRatingCode() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getGt123_GuarantorCreditRatingCode() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public DTM getGuarantorDeathDateAndTime() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public DTM getGt124_GuarantorDeathDateAndTime() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getGuarantorDeathFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getGt125_GuarantorDeathFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getGuarantorChargeAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getGt126_GuarantorChargeAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CP getGuarantorHouseholdAnnualIncome() {
        CP retVal = (CP)this.getTypedField(27, 0);
        return retVal;
    }

    public CP getGt127_GuarantorHouseholdAnnualIncome() {
        CP retVal = (CP)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getGuarantorHouseholdSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getGt128_GuarantorHouseholdSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public CX[] getGuarantorEmployerIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(29, new CX[0]);
        return retVal;
    }

    public CX[] getGt129_GuarantorEmployerIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(29, new CX[0]);
        return retVal;
    }

    public int getGuarantorEmployerIDNumberReps() {
        return this.getReps(29);
    }

    public CX getGuarantorEmployerIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(29, rep);
        return retVal;
    }

    public CX getGt129_GuarantorEmployerIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(29, rep);
        return retVal;
    }

    public int getGt129_GuarantorEmployerIDNumberReps() {
        return this.getReps(29);
    }

    public CX insertGuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(29, rep);
    }

    public CX insertGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(29, rep);
    }

    public CX removeGuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(29, rep);
    }

    public CX removeGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(29, rep);
    }

    public CWE getGuarantorMaritalStatusCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getGt130_GuarantorMaritalStatusCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getGuarantorHireEffectiveDate() {
        DT retVal = (DT)this.getTypedField(31, 0);
        return retVal;
    }

    public DT getGt131_GuarantorHireEffectiveDate() {
        DT retVal = (DT)this.getTypedField(31, 0);
        return retVal;
    }

    public DT getEmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public DT getGt132_EmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public IS getLivingDependency() {
        IS retVal = (IS)this.getTypedField(33, 0);
        return retVal;
    }

    public IS getGt133_LivingDependency() {
        IS retVal = (IS)this.getTypedField(33, 0);
        return retVal;
    }

    public IS[] getAmbulatoryStatus() {
        IS[] retVal = (IS[])this.getTypedField(34, new IS[0]);
        return retVal;
    }

    public IS[] getGt134_AmbulatoryStatus() {
        IS[] retVal = (IS[])this.getTypedField(34, new IS[0]);
        return retVal;
    }

    public int getAmbulatoryStatusReps() {
        return this.getReps(34);
    }

    public IS getAmbulatoryStatus(int rep) {
        IS retVal = (IS)this.getTypedField(34, rep);
        return retVal;
    }

    public IS getGt134_AmbulatoryStatus(int rep) {
        IS retVal = (IS)this.getTypedField(34, rep);
        return retVal;
    }

    public int getGt134_AmbulatoryStatusReps() {
        return this.getReps(34);
    }

    public IS insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(34, rep);
    }

    public IS insertGt134_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(34, rep);
    }

    public IS removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(34, rep);
    }

    public IS removeGt134_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(34, rep);
    }

    public CWE[] getCitizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(35, new CWE[0]);
        return retVal;
    }

    public CWE[] getGt135_Citizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(35, new CWE[0]);
        return retVal;
    }

    public int getCitizenshipReps() {
        return this.getReps(35);
    }

    public CWE getCitizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(35, rep);
        return retVal;
    }

    public CWE getGt135_Citizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(35, rep);
        return retVal;
    }

    public int getGt135_CitizenshipReps() {
        return this.getReps(35);
    }

    public CWE insertCitizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(35, rep);
    }

    public CWE insertGt135_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(35, rep);
    }

    public CWE removeCitizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(35, rep);
    }

    public CWE removeGt135_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(35, rep);
    }

    public CWE getPrimaryLanguage() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public CWE getGt136_PrimaryLanguage() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public IS getLivingArrangement() {
        IS retVal = (IS)this.getTypedField(37, 0);
        return retVal;
    }

    public IS getGt137_LivingArrangement() {
        IS retVal = (IS)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE getPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getGt138_PublicityCode() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getGt139_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public IS getStudentIndicator() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public IS getGt140_StudentIndicator() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getReligion() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE getGt141_Religion() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(42, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt142_MotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(42, new XPN[0]);
        return retVal;
    }

    public int getMotherSMaidenNameReps() {
        return this.getReps(42);
    }

    public XPN getMotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(42, rep);
        return retVal;
    }

    public XPN getGt142_MotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(42, rep);
        return retVal;
    }

    public int getGt142_MotherSMaidenNameReps() {
        return this.getReps(42);
    }

    public XPN insertMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(42, rep);
    }

    public XPN insertGt142_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(42, rep);
    }

    public XPN removeMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(42, rep);
    }

    public XPN removeGt142_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(42, rep);
    }

    public CWE getNationality() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public CWE getGt143_Nationality() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public CWE[] getEthnicGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(44, new CWE[0]);
        return retVal;
    }

    public CWE[] getGt144_EthnicGroup() {
        CWE[] retVal = (CWE[])this.getTypedField(44, new CWE[0]);
        return retVal;
    }

    public int getEthnicGroupReps() {
        return this.getReps(44);
    }

    public CWE getEthnicGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(44, rep);
        return retVal;
    }

    public CWE getGt144_EthnicGroup(int rep) {
        CWE retVal = (CWE)this.getTypedField(44, rep);
        return retVal;
    }

    public int getGt144_EthnicGroupReps() {
        return this.getReps(44);
    }

    public CWE insertEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(44, rep);
    }

    public CWE insertGt144_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(44, rep);
    }

    public CWE removeEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(44, rep);
    }

    public CWE removeGt144_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(44, rep);
    }

    public XPN[] getContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(45, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt145_ContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(45, new XPN[0]);
        return retVal;
    }

    public int getContactPersonSNameReps() {
        return this.getReps(45);
    }

    public XPN getContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(45, rep);
        return retVal;
    }

    public XPN getGt145_ContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(45, rep);
        return retVal;
    }

    public int getGt145_ContactPersonSNameReps() {
        return this.getReps(45);
    }

    public XPN insertContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(45, rep);
    }

    public XPN insertGt145_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(45, rep);
    }

    public XPN removeContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(45, rep);
    }

    public XPN removeGt145_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(45, rep);
    }

    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(46, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt146_ContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(46, new XTN[0]);
        return retVal;
    }

    public int getContactPersonSTelephoneNumberReps() {
        return this.getReps(46);
    }

    public XTN getContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(46, rep);
        return retVal;
    }

    public XTN getGt146_ContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(46, rep);
        return retVal;
    }

    public int getGt146_ContactPersonSTelephoneNumberReps() {
        return this.getReps(46);
    }

    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(46, rep);
    }

    public XTN insertGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(46, rep);
    }

    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(46, rep);
    }

    public XTN removeGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(46, rep);
    }

    public CWE getContactReason() {
        CWE retVal = (CWE)this.getTypedField(47, 0);
        return retVal;
    }

    public CWE getGt147_ContactReason() {
        CWE retVal = (CWE)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getContactRelationship() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public IS getGt148_ContactRelationship() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public ST getJobTitle() {
        ST retVal = (ST)this.getTypedField(49, 0);
        return retVal;
    }

    public ST getGt149_JobTitle() {
        ST retVal = (ST)this.getTypedField(49, 0);
        return retVal;
    }

    public JCC getJobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(50, 0);
        return retVal;
    }

    public JCC getGt150_JobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(50, 0);
        return retVal;
    }

    public XON[] getGuarantorEmployerSOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(51, new XON[0]);
        return retVal;
    }

    public XON[] getGt151_GuarantorEmployerSOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(51, new XON[0]);
        return retVal;
    }

    public int getGuarantorEmployerSOrganizationNameReps() {
        return this.getReps(51);
    }

    public XON getGuarantorEmployerSOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(51, rep);
        return retVal;
    }

    public XON getGt151_GuarantorEmployerSOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(51, rep);
        return retVal;
    }

    public int getGt151_GuarantorEmployerSOrganizationNameReps() {
        return this.getReps(51);
    }

    public XON insertGuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(51, rep);
    }

    public XON insertGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(51, rep);
    }

    public XON removeGuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(51, rep);
    }

    public XON removeGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(51, rep);
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(52, 0);
        return retVal;
    }

    public IS getGt152_Handicap() {
        IS retVal = (IS)this.getTypedField(52, 0);
        return retVal;
    }

    public IS getJobStatus() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    public IS getGt153_JobStatus() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    public FC getGuarantorFinancialClass() {
        FC retVal = (FC)this.getTypedField(54, 0);
        return retVal;
    }

    public FC getGt154_GuarantorFinancialClass() {
        FC retVal = (FC)this.getTypedField(54, 0);
        return retVal;
    }

    public CWE[] getGuarantorRace() {
        CWE[] retVal = (CWE[])this.getTypedField(55, new CWE[0]);
        return retVal;
    }

    public CWE[] getGt155_GuarantorRace() {
        CWE[] retVal = (CWE[])this.getTypedField(55, new CWE[0]);
        return retVal;
    }

    public int getGuarantorRaceReps() {
        return this.getReps(55);
    }

    public CWE getGuarantorRace(int rep) {
        CWE retVal = (CWE)this.getTypedField(55, rep);
        return retVal;
    }

    public CWE getGt155_GuarantorRace(int rep) {
        CWE retVal = (CWE)this.getTypedField(55, rep);
        return retVal;
    }

    public int getGt155_GuarantorRaceReps() {
        return this.getReps(55);
    }

    public CWE insertGuarantorRace(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(55, rep);
    }

    public CWE insertGt155_GuarantorRace(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(55, rep);
    }

    public CWE removeGuarantorRace(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(55, rep);
    }

    public CWE removeGt155_GuarantorRace(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(55, rep);
    }

    public ST getGuarantorBirthPlace() {
        ST retVal = (ST)this.getTypedField(56, 0);
        return retVal;
    }

    public ST getGt156_GuarantorBirthPlace() {
        ST retVal = (ST)this.getTypedField(56, 0);
        return retVal;
    }

    public IS getVIPIndicator() {
        IS retVal = (IS)this.getTypedField(57, 0);
        return retVal;
    }

    public IS getGt157_VIPIndicator() {
        IS retVal = (IS)this.getTypedField(57, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XPN(this.getMessage());
            }
            case 3: {
                return new XPN(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(68));
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new XAD(this.getMessage());
            }
            case 17: {
                return new XTN(this.getMessage());
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new XON(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new DTM(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CP(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CX(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new DT(this.getMessage());
            }
            case 31: {
                return new DT(this.getMessage());
            }
            case 32: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 34: {
                return new CWE(this.getMessage());
            }
            case 35: {
                return new CWE(this.getMessage());
            }
            case 36: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 39: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 40: {
                return new CWE(this.getMessage());
            }
            case 41: {
                return new XPN(this.getMessage());
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new CWE(this.getMessage());
            }
            case 44: {
                return new XPN(this.getMessage());
            }
            case 45: {
                return new XTN(this.getMessage());
            }
            case 46: {
                return new CWE(this.getMessage());
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 48: {
                return new ST(this.getMessage());
            }
            case 49: {
                return new JCC(this.getMessage());
            }
            case 50: {
                return new XON(this.getMessage());
            }
            case 51: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 52: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 53: {
                return new FC(this.getMessage());
            }
            case 54: {
                return new CWE(this.getMessage());
            }
            case 55: {
                return new ST(this.getMessage());
            }
            case 56: {
                return new IS(this.getMessage(), new Integer(99));
            }
        }
        return null;
    }
}

