/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.SQR_S25_SCHEDULE;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.QAK;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SQR_S25
extends AbstractMessage {
    public SQR_S25() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SQR_S25(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(SQR_S25_SCHEDULE.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SQR_S25 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public SQR_S25_SCHEDULE getSCHEDULE() {
        return (SQR_S25_SCHEDULE)this.getTyped("SCHEDULE", SQR_S25_SCHEDULE.class);
    }

    public SQR_S25_SCHEDULE getSCHEDULE(int rep) {
        return (SQR_S25_SCHEDULE)this.getTyped("SCHEDULE", rep, SQR_S25_SCHEDULE.class);
    }

    public int getSCHEDULEReps() {
        return this.getReps("SCHEDULE");
    }

    public List<SQR_S25_SCHEDULE> getSCHEDULEAll() throws HL7Exception {
        return this.getAllAsList("SCHEDULE", SQR_S25_SCHEDULE.class);
    }

    public void insertSCHEDULE(SQR_S25_SCHEDULE structure, int rep) throws HL7Exception {
        super.insertRepetition("SCHEDULE", (Structure)structure, rep);
    }

    public SQR_S25_SCHEDULE insertSCHEDULE(int rep) throws HL7Exception {
        return (SQR_S25_SCHEDULE)super.insertRepetition("SCHEDULE", rep);
    }

    public SQR_S25_SCHEDULE removeSCHEDULE(int rep) throws HL7Exception {
        return (SQR_S25_SCHEDULE)super.removeRepetition("SCHEDULE", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

