/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.model.*;

/**
 * <p>Represents a CSU_C09_ORCRXARXR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                         * <li>1: ORC (ORC - common order segment) <b>optional  </b></li>
                         * <li>2: CSU_C09_RXARXR (a Group object) <b> repeating </b></li>
 * </ul>
 */
//@SuppressWarnings("unused")
public class CSU_C09_ORCRXARXR extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_ORCRXARXR group
     */
    public CSU_C09_ORCRXARXR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ORC.class, false, false, false);
                                  this.add(CSU_C09_RXARXR.class, true, true, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating CSU_C09_ORCRXARXR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * ORC (ORC - common order segment) - creates it if necessary
     */
    public ORC getORC() { 
       ORC retVal = getTyped("ORC", ORC.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * RXARXR (a Group object) - creates it if necessary
     */
    public CSU_C09_RXARXR getRXARXR() { 
       CSU_C09_RXARXR retVal = getTyped("RXARXR", CSU_C09_RXARXR.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * RXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_RXARXR getRXARXR(int rep) { 
       CSU_C09_RXARXR retVal = getTyped("RXARXR", rep, CSU_C09_RXARXR.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of RXARXR 
     */ 
    public int getRXARXRReps() {  
        return getReps("RXARXR");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of RXARXR.
     * <p>
     * <p>
     * Note that unlike {@link #getRXARXR()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public java.util.List<CSU_C09_RXARXR> getRXARXRAll() throws HL7Exception {
    	return getAllAsList("RXARXR", CSU_C09_RXARXR.class);
    } 

    /**
     * Inserts a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRXARXR(CSU_C09_RXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition("RXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_RXARXR insertRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_RXARXR)super.insertRepetition("RXARXR", rep);
    }


    /**
     * Removes a specific repetition of RXARXR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_RXARXR removeRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_RXARXR)super.removeRepetition("RXARXR", rep);
    }



}

