/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.EI;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.PL;
import ca.uhn.hl7v2.model.v231.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LRL
extends AbstractSegment {
    public LRL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 200, new Object[]{this.getMessage()}, "Primary Key Value - LRL");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Segment Unique Key");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Location Relationship ID");
            this.add(XON.class, false, 0, 80, new Object[]{this.getMessage()}, "Organizational Location Relationship Value");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Patient Location Relationship Value");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LRL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLRL() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLrl1_PrimaryKeyValueLRL() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getLrl2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getLrl3_SegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getLocationRelationshipID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getLrl4_LocationRelationshipID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public XON[] getOrganizationalLocationRelationshipValue() {
        XON[] retVal = (XON[])this.getTypedField(5, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getLrl5_OrganizationalLocationRelationshipValue() {
        XON[] retVal = (XON[])this.getTypedField(5, (Type[])new XON[0]);
        return retVal;
    }

    public int getOrganizationalLocationRelationshipValueReps() {
        return this.getReps(5);
    }

    public XON getOrganizationalLocationRelationshipValue(int rep) {
        XON retVal = (XON)this.getTypedField(5, rep);
        return retVal;
    }

    public XON getLrl5_OrganizationalLocationRelationshipValue(int rep) {
        XON retVal = (XON)this.getTypedField(5, rep);
        return retVal;
    }

    public int getLrl5_OrganizationalLocationRelationshipValueReps() {
        return this.getReps(5);
    }

    public XON insertOrganizationalLocationRelationshipValue(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(5, rep);
    }

    public XON insertLrl5_OrganizationalLocationRelationshipValue(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(5, rep);
    }

    public XON removeOrganizationalLocationRelationshipValue(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(5, rep);
    }

    public XON removeLrl5_OrganizationalLocationRelationshipValue(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(5, rep);
    }

    public PL getPatientLocationRelationshipValue() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    public PL getLrl6_PatientLocationRelationshipValue() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new XON(this.getMessage());
            }
            case 5: {
                return new PL(this.getMessage());
            }
        }
        return null;
    }
}

