/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIP
extends AbstractSegment {
    public AIP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIP");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Personnel Resource ID");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Resource Type");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Resource Group");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAip1_SetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAip2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getPersonnelResourceID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getAip3_PersonnelResourceID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPersonnelResourceIDReps() {
        return this.getReps(3);
    }

    public XCN getPersonnelResourceID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getAip3_PersonnelResourceID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getAip3_PersonnelResourceIDReps() {
        return this.getReps(3);
    }

    public XCN insertPersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertAip3_PersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removePersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeAip3_PersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public CE getResourceType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAip4_ResourceType() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getResourceGroup() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getAip5_ResourceGroup() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getStartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getAip6_StartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAip7_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getStartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getAip8_StartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAip9_Duration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getAip10_DurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getAip11_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getFillerStatusCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getAip12_FillerStatusCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 11: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

