/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.FT;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.ST;

public class CF
extends AbstractComposite {
    private Type[] data;

    public CF(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FT(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 396);
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new FT(this.getMessage());
        this.data[5] = new ID(this.getMessage(), 396);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIdentifier() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getCf1_Identifier() {
        return (ST)this.getTyped(0, ST.class);
    }

    public FT getFormattedText() {
        return (FT)this.getTyped(1, FT.class);
    }

    public FT getCf2_FormattedText() {
        return (FT)this.getTyped(1, FT.class);
    }

    public ID getNameOfCodingSystem() {
        return (ID)this.getTyped(2, ID.class);
    }

    public ID getCf3_NameOfCodingSystem() {
        return (ID)this.getTyped(2, ID.class);
    }

    public ST getAlternateIdentifier() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getCf4_AlternateIdentifier() {
        return (ST)this.getTyped(3, ST.class);
    }

    public FT getAlternateFormattedText() {
        return (FT)this.getTyped(4, FT.class);
    }

    public FT getCf5_AlternateFormattedText() {
        return (FT)this.getTyped(4, FT.class);
    }

    public ID getNameOfAlternateCodingSystem() {
        return (ID)this.getTyped(5, ID.class);
    }

    public ID getCf6_NameOfAlternateCodingSystem() {
        return (ID)this.getTyped(5, ID.class);
    }
}

