/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RPL_I02_PROVIDER;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.DSP;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPL_I02
extends AbstractMessage {
    public RPL_I02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RPL_I02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(RPL_I02_PROVIDER.class, true, true);
            this.add(NTE.class, false, true);
            this.add(DSP.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPL_I02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public RPL_I02_PROVIDER getPROVIDER() {
        return (RPL_I02_PROVIDER)this.getTyped("PROVIDER", RPL_I02_PROVIDER.class);
    }

    public RPL_I02_PROVIDER getPROVIDER(int rep) {
        return (RPL_I02_PROVIDER)this.getTyped("PROVIDER", rep, RPL_I02_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RPL_I02_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RPL_I02_PROVIDER.class);
    }

    public void insertPROVIDER(RPL_I02_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", (Structure)structure, rep);
    }

    public RPL_I02_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPL_I02_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPL_I02_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPL_I02_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public DSP getDSP() {
        return (DSP)this.getTyped("DSP", DSP.class);
    }

    public DSP getDSP(int rep) {
        return (DSP)this.getTyped("DSP", rep, DSP.class);
    }

    public int getDSPReps() {
        return this.getReps("DSP");
    }

    public List<DSP> getDSPAll() throws HL7Exception {
        return this.getAllAsList("DSP", DSP.class);
    }

    public void insertDSP(DSP structure, int rep) throws HL7Exception {
        super.insertRepetition("DSP", (Structure)structure, rep);
    }

    public DSP insertDSP(int rep) throws HL7Exception {
        return (DSP)super.insertRepetition("DSP", rep);
    }

    public DSP removeDSP(int rep) throws HL7Exception {
        return (DSP)super.removeRepetition("DSP", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

