/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E24_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E24
extends AbstractMessage {
    public EHC_E24() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E24(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(IVC.class, true, false);
            this.add(EHC_E24_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E24 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return (UAC)this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public IVC getIVC() {
        return (IVC)this.getTyped("IVC", IVC.class);
    }

    public EHC_E24_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        return (EHC_E24_PSL_ITEM_INFO)this.getTyped("PSL_ITEM_INFO", EHC_E24_PSL_ITEM_INFO.class);
    }

    public EHC_E24_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        return (EHC_E24_PSL_ITEM_INFO)this.getTyped("PSL_ITEM_INFO", rep, EHC_E24_PSL_ITEM_INFO.class);
    }

    public int getPSL_ITEM_INFOReps() {
        return this.getReps("PSL_ITEM_INFO");
    }

    public List<EHC_E24_PSL_ITEM_INFO> getPSL_ITEM_INFOAll() throws HL7Exception {
        return this.getAllAsList("PSL_ITEM_INFO", EHC_E24_PSL_ITEM_INFO.class);
    }

    public void insertPSL_ITEM_INFO(EHC_E24_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", (Structure)structure, rep);
    }

    public EHC_E24_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E24_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public EHC_E24_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E24_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

