/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.FT;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PES
extends AbstractSegment {
    public PES(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XON.class, false, 0, 567, new Object[]{this.getMessage()}, "Sender Organization Name");
            this.add(XCN.class, false, 0, 3220, new Object[]{this.getMessage()}, "Sender Individual Name");
            this.add(XAD.class, false, 0, 2915, new Object[]{this.getMessage()}, "Sender Address");
            this.add(XTN.class, false, 0, 2743, new Object[]{this.getMessage()}, "Sender Telephone");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage()}, "Sender Event Identifier");
            this.add(NM.class, false, 1, 16, new Object[]{this.getMessage()}, "Sender Sequence Number");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Sender Event Description");
            this.add(FT.class, false, 1, 600, new Object[]{this.getMessage()}, "Sender Comment");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Sender Aware Date/Time");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Event Report Date");
            this.add(ID.class, false, 2, 3, new Object[]{this.getMessage(), new Integer(234)}, "Event Report Timing/Type");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(235)}, "Event Report Source");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(236)}, "Event Reported To");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PES - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public XON[] getSenderOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(1, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getPes1_SenderOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(1, (Type[])new XON[0]);
        return retVal;
    }

    public int getSenderOrganizationNameReps() {
        return this.getReps(1);
    }

    public XON getSenderOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(1, rep);
        return retVal;
    }

    public XON getPes1_SenderOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPes1_SenderOrganizationNameReps() {
        return this.getReps(1);
    }

    public XON insertSenderOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(1, rep);
    }

    public XON insertPes1_SenderOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(1, rep);
    }

    public XON removeSenderOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(1, rep);
    }

    public XON removePes1_SenderOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(1, rep);
    }

    public XCN[] getSenderIndividualName() {
        XCN[] retVal = (XCN[])this.getTypedField(2, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getPes2_SenderIndividualName() {
        XCN[] retVal = (XCN[])this.getTypedField(2, (Type[])new XCN[0]);
        return retVal;
    }

    public int getSenderIndividualNameReps() {
        return this.getReps(2);
    }

    public XCN getSenderIndividualName(int rep) {
        XCN retVal = (XCN)this.getTypedField(2, rep);
        return retVal;
    }

    public XCN getPes2_SenderIndividualName(int rep) {
        XCN retVal = (XCN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPes2_SenderIndividualNameReps() {
        return this.getReps(2);
    }

    public XCN insertSenderIndividualName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(2, rep);
    }

    public XCN insertPes2_SenderIndividualName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(2, rep);
    }

    public XCN removeSenderIndividualName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(2, rep);
    }

    public XCN removePes2_SenderIndividualName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(2, rep);
    }

    public XAD[] getSenderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getPes3_SenderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, (Type[])new XAD[0]);
        return retVal;
    }

    public int getSenderAddressReps() {
        return this.getReps(3);
    }

    public XAD getSenderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public XAD getPes3_SenderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPes3_SenderAddressReps() {
        return this.getReps(3);
    }

    public XAD insertSenderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD insertPes3_SenderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD removeSenderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XAD removePes3_SenderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XTN[] getSenderTelephone() {
        XTN[] retVal = (XTN[])this.getTypedField(4, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getPes4_SenderTelephone() {
        XTN[] retVal = (XTN[])this.getTypedField(4, (Type[])new XTN[0]);
        return retVal;
    }

    public int getSenderTelephoneReps() {
        return this.getReps(4);
    }

    public XTN getSenderTelephone(int rep) {
        XTN retVal = (XTN)this.getTypedField(4, rep);
        return retVal;
    }

    public XTN getPes4_SenderTelephone(int rep) {
        XTN retVal = (XTN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPes4_SenderTelephoneReps() {
        return this.getReps(4);
    }

    public XTN insertSenderTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(4, rep);
    }

    public XTN insertPes4_SenderTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(4, rep);
    }

    public XTN removeSenderTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(4, rep);
    }

    public XTN removePes4_SenderTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(4, rep);
    }

    public EI getSenderEventIdentifier() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getPes5_SenderEventIdentifier() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getSenderSequenceNumber() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getPes6_SenderSequenceNumber() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public FT[] getSenderEventDescription() {
        FT[] retVal = (FT[])this.getTypedField(7, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPes7_SenderEventDescription() {
        FT[] retVal = (FT[])this.getTypedField(7, (Type[])new FT[0]);
        return retVal;
    }

    public int getSenderEventDescriptionReps() {
        return this.getReps(7);
    }

    public FT getSenderEventDescription(int rep) {
        FT retVal = (FT)this.getTypedField(7, rep);
        return retVal;
    }

    public FT getPes7_SenderEventDescription(int rep) {
        FT retVal = (FT)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPes7_SenderEventDescriptionReps() {
        return this.getReps(7);
    }

    public FT insertSenderEventDescription(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(7, rep);
    }

    public FT insertPes7_SenderEventDescription(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(7, rep);
    }

    public FT removeSenderEventDescription(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(7, rep);
    }

    public FT removePes7_SenderEventDescription(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(7, rep);
    }

    public FT getSenderComment() {
        FT retVal = (FT)this.getTypedField(8, 0);
        return retVal;
    }

    public FT getPes8_SenderComment() {
        FT retVal = (FT)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getSenderAwareDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getPes9_SenderAwareDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getEventReportDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getPes10_EventReportDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public ID[] getEventReportTimingType() {
        ID[] retVal = (ID[])this.getTypedField(11, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPes11_EventReportTimingType() {
        ID[] retVal = (ID[])this.getTypedField(11, (Type[])new ID[0]);
        return retVal;
    }

    public int getEventReportTimingTypeReps() {
        return this.getReps(11);
    }

    public ID getEventReportTimingType(int rep) {
        ID retVal = (ID)this.getTypedField(11, rep);
        return retVal;
    }

    public ID getPes11_EventReportTimingType(int rep) {
        ID retVal = (ID)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPes11_EventReportTimingTypeReps() {
        return this.getReps(11);
    }

    public ID insertEventReportTimingType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID insertPes11_EventReportTimingType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID removeEventReportTimingType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID removePes11_EventReportTimingType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID getEventReportSource() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPes12_EventReportSource() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID[] getEventReportedTo() {
        ID[] retVal = (ID[])this.getTypedField(13, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPes13_EventReportedTo() {
        ID[] retVal = (ID[])this.getTypedField(13, (Type[])new ID[0]);
        return retVal;
    }

    public int getEventReportedToReps() {
        return this.getReps(13);
    }

    public ID getEventReportedTo(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public ID getPes13_EventReportedTo(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPes13_EventReportedToReps() {
        return this.getReps(13);
    }

    public ID insertEventReportedTo(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID insertPes13_EventReportedTo(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID removeEventReportedTo(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    public ID removePes13_EventReportedTo(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XON(this.getMessage());
            }
            case 1: {
                return new XCN(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new XTN(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new FT(this.getMessage());
            }
            case 7: {
                return new FT(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new DTM(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(234));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(235));
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(236));
            }
        }
        return null;
    }
}

