/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDC {
    private static final ThreadLocal<HashMap<String, String>> threadLocal = new ThreadLocal();

    private MDC() {
    }

    public static void put(String key, String val) {
        HashMap<String, String> oldMap = threadLocal.get();
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (oldMap != null) {
            newMap.putAll(oldMap);
        }
        threadLocal.set(newMap);
        newMap.put(key, val);
    }

    public static String get(String key) {
        HashMap<String, String> hashMap = threadLocal.get();
        if (hashMap != null && key != null) {
            return hashMap.get(key);
        }
        return null;
    }

    public static void remove(String key) {
        HashMap<String, String> oldMap = threadLocal.get();
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (oldMap != null) {
            newMap.putAll(oldMap);
        }
        threadLocal.set(newMap);
        newMap.remove(key);
    }

    public static void clear() {
        HashMap<String, String> hashMap = threadLocal.get();
        if (hashMap != null) {
            hashMap.clear();
            threadLocal.remove();
        }
    }

    public static Map<String, String> getPropertyMap() {
        return threadLocal.get();
    }

    public static Set<String> getKeys() {
        HashMap<String, String> hashMap = threadLocal.get();
        if (hashMap != null) {
            return hashMap.keySet();
        }
        return null;
    }
}

