/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.joran.PropertiesConfigurator;
import ch.qos.logback.classic.model.PropertiesConfiguratorModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.ResourceHandlerBase;
import ch.qos.logback.core.util.OptionHelper;
import java.io.InputStream;
import java.net.URL;

public class PropertiesConfiguratorModelHandler
extends ResourceHandlerBase {
    boolean inError = false;
    static final boolean CREATE_CWL_IF_NOT_ALREADY_CREATED = true;

    public PropertiesConfiguratorModelHandler(Context context) {
        super(context);
    }

    public static PropertiesConfiguratorModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        return new PropertiesConfiguratorModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        PropertiesConfiguratorModel propertyConfiguratorModel = (PropertiesConfiguratorModel)model;
        this.optional = OptionHelper.toBoolean((String)propertyConfiguratorModel.getOptional(), (boolean)false);
        if (!this.checkAttributes(propertyConfiguratorModel)) {
            this.inError = true;
            return;
        }
        InputStream in = this.getInputStream(mic, propertyConfiguratorModel);
        if (in == null) {
            this.inError = true;
            return;
        }
        this.addInfo("Reading configuration from [" + this.getAttribureInUse() + "]");
        PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator();
        propertiesConfigurator.setContext(mic.getContext());
        try {
            propertiesConfigurator.doConfigure(in);
        }
        catch (JoranException e) {
            this.addError("Could not configure from " + this.getAttribureInUse());
            throw new ModelHandlerException((Throwable)e);
        }
    }

    protected InputStream getInputStream(ModelInterpretationContext mic, ResourceModel resourceModel) {
        URL inputURL = this.getInputURL(mic, resourceModel);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList((Context)this.context, (URL)inputURL, (boolean)true);
        return this.openURL(inputURL);
    }
}

