/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.logic.creating.filesystem.hints;

import ch.tutteli.atrium.assertions.Assertion;
import ch.tutteli.atrium.assertions.AssertionGroup;
import ch.tutteli.atrium.assertions.DescriptiveAssertion;
import ch.tutteli.atrium.assertions.ExplanatoryAssertion;
import ch.tutteli.atrium.assertions.builders.AssertionBuilderKt;
import ch.tutteli.atrium.assertions.builders.AssertionsOption;
import ch.tutteli.atrium.assertions.builders.Descriptive;
import ch.tutteli.atrium.assertions.builders.DescriptiveAssertionWithFailureHint;
import ch.tutteli.atrium.assertions.builders.DescriptiveWithFailureHintKt;
import ch.tutteli.atrium.assertions.builders.Explanatory;
import ch.tutteli.atrium.assertions.builders.ExplanatoryGroup;
import ch.tutteli.atrium.assertions.builders.ExplanatoryGroupKt;
import ch.tutteli.atrium.core.polyfills.KClassExtensionsKt;
import ch.tutteli.atrium.creating.AssertionContainer;
import ch.tutteli.atrium.creating.Expect;
import ch.tutteli.atrium.logic.UtilsKt;
import ch.tutteli.atrium.logic.creating.filesystem.Failure;
import ch.tutteli.atrium.logic.creating.filesystem.IoResult;
import ch.tutteli.atrium.logic.creating.filesystem.Success;
import ch.tutteli.atrium.logic.creating.filesystem.hints.HintsKt;
import ch.tutteli.atrium.logic.creating.transformers.impl.ThrowableThrownFailureHandler;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.translations.DescriptionBasic;
import ch.tutteli.atrium.translations.DescriptionPathAssertion;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u00c0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002\u001a \u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a1\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\n0\u0014\u001a\u001a\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0016\u0010#\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u000e\u0010$\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0012\u0010%\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002\u001a%\u0010'\u001a\u00020\n\"\b\b\u0000\u0010(*\u00020\u00062\u0006\u0010)\u001a\u0002H(2\u0006\u0010*\u001a\u00020\u0001\u00a2\u0006\u0002\u0010+\u001a\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0006002\u0006\u00101\u001a\u000202H\u0002\u001a\b\u00103\u001a\u00020 H\u0002\u001a\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u0001H\u0002\u001a\u0010\u00106\u001a\u00020 2\u0006\u00107\u001a\u000208H\u0002\u001a\u0018\u00109\u001a\u00020 2\u0006\u00107\u001a\u0002082\u0006\u0010:\u001a\u000208H\u0002\u001a\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0<2\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0018\u0010=\u001a\u00020-2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\nH\u0002\u001a!\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\"00H\u0002\u00a2\u0006\u0002\u0010B\u001a2\u0010C\u001a\u00060\u0019j\u0002`\u001a2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001d2\u0006\u0010G\u001a\u00020\u001dH\u0002\u001a\u0018\u0010H\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030I2\u0006\u0010\u0007\u001a\u00020\u0006\u001a \u0010J\u001a\u00020\n*\u0006\u0012\u0002\b\u00030I2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0002\u001a\u001e\u0010M\u001a\u00020\n*\u0006\u0012\u0002\b\u00030I2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010K\u001a\u00020L\u001a\u0018\u0010N\u001a\u00020-*\u0006\u0012\u0002\b\u00030I2\u0006\u0010K\u001a\u00020LH\u0002\u001a*\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P*\b\u0012\u0004\u0012\u00020R0P2\u0012\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020U0T\u001aT\u0010V\u001a\b\u0012\u0004\u0012\u00020Q0P\"\u0004\b\u0000\u0010(*\b\u0012\u0004\u0012\u00020R0P2\u0012\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0U0T2\u001c\b\u0004\u0010W\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020L\u0012\u0006\u0012\u0004\u0018\u00010\n0XH\u0086\b\u00f8\u0001\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006Y"}, d2={"fileType", "Lch/tutteli/atrium/reporting/translating/Translatable;", "Ljava/nio/file/attribute/BasicFileAttributes;", "getFileType", "(Ljava/nio/file/attribute/BasicFileAttributes;)Lch/tutteli/atrium/reporting/translating/Translatable;", "addAllLevelResolvedSymlinkHints", "Ljava/nio/file/Path;", "path", "hintList", "Ljava/util/Deque;", "Lch/tutteli/atrium/assertions/Assertion;", "absolutePath", "loopDetection", "Ljava/util/Stack;", "addOneStepResolvedSymlinkHint", "describeWas", "Lch/tutteli/atrium/assertions/DescriptiveAssertion;", "actual", "explainForResolvedLink", "resolvedPathAssertionProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "realPath", "formatPosixPermissions", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "filePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "hintForAccessDenied", "hintForAclEntry", "Lch/tutteli/atrium/assertions/ExplanatoryAssertion;", "entry", "Ljava/nio/file/attribute/AclEntry;", "hintForActualPosixPermissions", "hintForClosestExistingParent", "hintForExistingParentDirectory", "parent", "hintForExistsButMissingPermission", "T", "subject", "permissionName", "(Ljava/nio/file/Path;Lch/tutteli/atrium/reporting/translating/Translatable;)Lch/tutteli/atrium/assertions/Assertion;", "hintForFileNotFound", "Lch/tutteli/atrium/assertions/AssertionGroup;", "hintForLinkLoop", "loop", "", "startIndex", "", "hintForNoSuchFile", "hintForNotDirectory", "actualType", "hintForOwner", "owner", "", "hintForOwnerAndGroup", "group", "hintForOwnersAndPermissions", "", "hintForParentFailure", "explanation", "hintsForActualAclPermissions", "", "acl", "(Ljava/util/List;)[Lch/tutteli/atrium/assertions/Assertion;", "toPermissionString", "permissions", "readPermission", "writePermission", "executePermission", "findHintForProblemWithParent", "Lch/tutteli/atrium/creating/AssertionContainer;", "hintForFileSpecificIoException", "exception", "Ljava/io/IOException;", "hintForIoException", "hintForOtherIoException", "withHelpOnFileAttributesFailure", "Lch/tutteli/atrium/assertions/builders/Descriptive$DescriptionOption;", "Lch/tutteli/atrium/assertions/builders/DescriptiveAssertionWithFailureHint$FinalStep;", "Lch/tutteli/atrium/assertions/builders/Descriptive$FinalStep;", "expect", "Lch/tutteli/atrium/creating/Expect;", "Lch/tutteli/atrium/logic/creating/filesystem/IoResult;", "withHelpOnIOExceptionFailure", "f", "Lkotlin/Function2;", "atrium-logic"})
@SourceDebugExtension(value={"SMAP\nhints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hints.kt\nch/tutteli/atrium/logic/creating/filesystem/hints/HintsKt\n+ 2 pathDelegateToFiles.kt\nch/tutteli/niok/PathDelegateToFilesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n65#2:407\n210#2:408\n134#2:409\n134#2:410\n210#2:415\n210#2:416\n1549#3:411\n1620#3,3:412\n*E\n*S KotlinDebug\n*F\n+ 1 hints.kt\nch/tutteli/atrium/logic/creating/filesystem/hints/HintsKt\n*L\n133#1:407\n164#1:408\n228#1:409\n233#1:410\n325#1:415\n365#1:416\n259#1:411\n259#1,3:412\n*E\n"})
public final class HintsKt {
    @NotNull
    public static final <T> Descriptive.DescriptionOption<DescriptiveAssertionWithFailureHint.FinalStep> withHelpOnIOExceptionFailure(@NotNull Descriptive.DescriptionOption<Descriptive.FinalStep> $this$withHelpOnIOExceptionFailure, @NotNull Expect<IoResult<T>> expect, @NotNull Function2<? super Path, ? super IOException, ? extends Assertion> f) {
        Intrinsics.checkNotNullParameter($this$withHelpOnIOExceptionFailure, (String)"<this>");
        Intrinsics.checkNotNullParameter(expect, (String)"expect");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$withHelpOnIOExceptionFailure = false;
        return DescriptiveWithFailureHintKt.withHelpOnFailureBasedOnDefinedSubject($this$withHelpOnIOExceptionFailure, expect, (Function1)withHelpOnIOExceptionFailure.1.INSTANCE, (Function1)new Function1<IoResult<? extends T>, Assertion>(f, expect){
            final /* synthetic */ Function2<Path, IOException, Assertion> $f;
            final /* synthetic */ Expect<IoResult<T>> $expect;
            {
                this.$f = $f;
                this.$expect = $expect;
                super(1);
            }

            @NotNull
            public final Assertion invoke(@NotNull IoResult<? extends T> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                return HintsKt.explainForResolvedLink(result.getPath(), (Function1<? super Path, ? extends Assertion>)((Function1)new Function1<Path, Assertion>(result, this.$f, this.$expect){
                    final /* synthetic */ IoResult<T> $result;
                    final /* synthetic */ Function2<Path, IOException, Assertion> $f;
                    final /* synthetic */ Expect<IoResult<T>> $expect;
                    {
                        this.$result = $result;
                        this.$f = $f;
                        this.$expect = $expect;
                        super(1);
                    }

                    @NotNull
                    public final Assertion invoke(@NotNull Path realPath) {
                        Intrinsics.checkNotNullParameter((Object)realPath, (String)"realPath");
                        IoResult<T> ioResult = this.$result;
                        Intrinsics.checkNotNull(ioResult, (String)"null cannot be cast to non-null type ch.tutteli.atrium.logic.creating.filesystem.Failure");
                        IOException exception = ((Failure)ioResult).getException();
                        Assertion assertion2 = (Assertion)this.$f.invoke((Object)realPath, (Object)exception);
                        if (assertion2 == null) {
                            Expect<IoResult<T>> $this$_logic$iv = this.$expect;
                            boolean $i$f$get_logic = false;
                            assertion2 = HintsKt.hintForIoException(UtilsKt.toAssertionContainer($this$_logic$iv), realPath, exception);
                        }
                        return assertion2;
                    }
                }));
            }
        });
    }

    @NotNull
    public static final Descriptive.DescriptionOption<DescriptiveAssertionWithFailureHint.FinalStep> withHelpOnFileAttributesFailure(@NotNull Descriptive.DescriptionOption<Descriptive.FinalStep> $this$withHelpOnFileAttributesFailure, @NotNull Expect<IoResult<BasicFileAttributes>> expect) {
        Intrinsics.checkNotNullParameter($this$withHelpOnFileAttributesFailure, (String)"<this>");
        Intrinsics.checkNotNullParameter(expect, (String)"expect");
        return DescriptiveWithFailureHintKt.withHelpOnFailureBasedOnDefinedSubject$default($this$withHelpOnFileAttributesFailure, expect, null, (Function1)((Function1)new Function1<IoResult<? extends BasicFileAttributes>, Assertion>(expect){
            final /* synthetic */ Expect<IoResult<BasicFileAttributes>> $expect;
            {
                this.$expect = $expect;
                super(1);
            }

            @NotNull
            public final Assertion invoke(@NotNull IoResult<? extends BasicFileAttributes> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                return HintsKt.explainForResolvedLink(result.getPath(), (Function1<? super Path, ? extends Assertion>)((Function1)new Function1<Path, Assertion>(result, this.$expect){
                    final /* synthetic */ IoResult<BasicFileAttributes> $result;
                    final /* synthetic */ Expect<IoResult<BasicFileAttributes>> $expect;
                    {
                        this.$result = $result;
                        this.$expect = $expect;
                        super(1);
                    }

                    @NotNull
                    public final Assertion invoke(@NotNull Path realPath) {
                        Assertion assertion2;
                        Intrinsics.checkNotNullParameter((Object)realPath, (String)"realPath");
                        IoResult<BasicFileAttributes> ioResult = this.$result;
                        if (ioResult instanceof Success) {
                            assertion2 = (Assertion)HintsKt.access$describeWas(HintsKt.access$getFileType((BasicFileAttributes)((Success)this.$result).getValue()));
                        } else if (ioResult instanceof Failure) {
                            Expect<IoResult<BasicFileAttributes>> $this$_logic$iv = this.$expect;
                            boolean $i$f$get_logic = false;
                            assertion2 = HintsKt.hintForIoException(UtilsKt.toAssertionContainer($this$_logic$iv), realPath, ((Failure)this.$result).getException());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return assertion2;
                    }
                }));
            }
        }), (int)2, null);
    }

    @NotNull
    public static final Assertion explainForResolvedLink(@NotNull Path path, @NotNull Function1<? super Path, ? extends Assertion> resolvedPathAssertionProvider) {
        Assertion assertion2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(resolvedPathAssertionProvider, (String)"resolvedPathAssertionProvider");
        LinkedList<Assertion> hintList = new LinkedList<Assertion>();
        Path realPath = HintsKt.addAllLevelResolvedSymlinkHints(path, (Deque<Assertion>)hintList);
        Assertion resolvedPathAssertion = (Assertion)resolvedPathAssertionProvider.invoke((Object)realPath);
        if (!((Collection)hintList).isEmpty()) {
            if (resolvedPathAssertion instanceof AssertionGroup) {
                hintList.addAll(((AssertionGroup)resolvedPathAssertion).getAssertions());
            } else {
                hintList.add(resolvedPathAssertion);
            }
            assertion2 = ((ExplanatoryGroup.FinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertions((List)hintList)).build();
        } else {
            assertion2 = resolvedPathAssertion;
        }
        return assertion2;
    }

    private static final Path addAllLevelResolvedSymlinkHints(Path path, Deque<Assertion> hintList) {
        Path absolutePath = path.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)absolutePath, (String)"absolutePath");
        return HintsKt.addAllLevelResolvedSymlinkHints(absolutePath, hintList, new Stack<Path>());
    }

    private static final Path addAllLevelResolvedSymlinkHints(Path absolutePath, Deque<Assertion> hintList, Stack<Path> loopDetection) {
        Path currentPath = absolutePath.getRoot();
        for (Path part : absolutePath) {
            int loopDetectionIndex = loopDetection.indexOf(currentPath = currentPath.resolve(part));
            if (loopDetectionIndex != -1) {
                loopDetection.add(currentPath);
                hintList.add(HintsKt.hintForLinkLoop((List<? extends Path>)loopDetection, loopDetectionIndex));
                return absolutePath;
            }
            Path path = currentPath;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"currentPath");
            Path nextPathAfterFollowSymbolicLink = HintsKt.addOneStepResolvedSymlinkHint(path, hintList);
            if (nextPathAfterFollowSymbolicLink == null) continue;
            loopDetection.push(currentPath);
            currentPath = HintsKt.addAllLevelResolvedSymlinkHints(nextPathAfterFollowSymbolicLink, hintList, loopDetection);
            loopDetection.pop();
        }
        Path path = currentPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"currentPath");
        return path;
    }

    private static final Assertion hintForLinkLoop(List<? extends Path> loop, int startIndex) {
        String loopRepresentation = CollectionsKt.joinToString$default((Iterable)loop.subList(startIndex, loop.size()), (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null);
        return ExplanatoryGroupKt.withExplanatoryAssertion((AssertionsOption)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithWarningType(), (Translatable)((Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_LINK_LOOP), (Object)loopRepresentation, (Object[])new Object[0]).build();
    }

    private static final Path addOneStepResolvedSymlinkHint(Path absolutePath, Deque<Assertion> hintList) {
        Path path;
        try {
            Object[] $this$followSymbolicLink$iv = absolutePath;
            boolean $i$f$followSymbolicLink = false;
            Path nextPath = absolutePath.resolveSibling(Files.readSymbolicLink((Path)$this$followSymbolicLink$iv)).normalize();
            Explanatory.ExplanationOption explanationOption = AssertionBuilderKt.getAssertionBuilder().getExplanatory();
            Translatable translatable = (Translatable)DescriptionPathAssertion.HINT_FOLLOWED_SYMBOLIC_LINK;
            $this$followSymbolicLink$iv = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)nextPath, (String)"nextPath");
            $this$followSymbolicLink$iv[0] = nextPath;
            hintList.add(explanationOption.withExplanation(translatable, (Object)absolutePath, $this$followSymbolicLink$iv).build());
        }
        catch (IOException e) {
            path = null;
        }
        return path;
    }

    @NotNull
    public static final Assertion hintForIoException(@NotNull AssertionContainer<?> $this$hintForIoException, @NotNull Path path, @NotNull IOException exception) {
        Assertion assertion2;
        Intrinsics.checkNotNullParameter($this$hintForIoException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof NoSuchFileException) {
            assertion2 = (Assertion)HintsKt.hintForFileNotFound(path);
        } else {
            assertion2 = HintsKt.findHintForProblemWithParent($this$hintForIoException, path);
            if (assertion2 == null) {
                assertion2 = HintsKt.hintForFileSpecificIoException($this$hintForIoException, path, exception);
            }
        }
        return assertion2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Assertion findHintForProblemWithParent(@NotNull AssertionContainer<?> $this$findHintForProblemWithParent, @NotNull Path path) {
        Intrinsics.checkNotNullParameter($this$findHintForProblemWithParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path absolutePath = path.toAbsolutePath();
        Path currentParentPart = absolutePath.getRoot();
        for (Path part : absolutePath) {
            if (Intrinsics.areEqual((Object)(currentParentPart = currentParentPart.resolve(part)), (Object)path)) continue;
            try {
                BasicFileAttributes attributes;
                void $this$readAttributes$iv;
                Intrinsics.checkNotNullExpressionValue((Object)currentParentPart, (String)"currentParentPart");
                LinkOption[] linkOptions$iv = new LinkOption[]{};
                boolean $i$f$readAttributes = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.readAttributes((Path)$this$readAttributes$iv, BasicFileAttributes.class, Arrays.copyOf(linkOptions$iv, linkOptions$iv.length)), (String)"readAttributes(this, A::class.java, *linkOptions)");
                if (attributes.isDirectory()) continue;
                Path path2 = currentParentPart;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"currentParentPart");
                return (Assertion)HintsKt.hintForParentFailure(path2, (Assertion)HintsKt.hintForNotDirectory(HintsKt.getFileType(attributes)));
            }
            catch (AccessDeniedException e) {
                Path path3 = currentParentPart.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"currentParentPart.parent");
                Path path4 = currentParentPart.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"currentParentPart.parent");
                return (Assertion)HintsKt.hintForParentFailure(path3, HintsKt.hintForAccessDenied(path4));
            }
            catch (IOException e) {
                Path path5 = currentParentPart;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"currentParentPart");
                Path path6 = currentParentPart;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"currentParentPart");
                return (Assertion)HintsKt.hintForParentFailure(path5, HintsKt.hintForFileSpecificIoException($this$findHintForProblemWithParent, path6, e));
            }
        }
        return null;
    }

    private static final Translatable getFileType(BasicFileAttributes $this$fileType) {
        return $this$fileType.isRegularFile() ? (Translatable)DescriptionPathAssertion.A_FILE : ($this$fileType.isDirectory() ? (Translatable)DescriptionPathAssertion.A_DIRECTORY : ($this$fileType.isSymbolicLink() ? (Translatable)DescriptionPathAssertion.A_SYMBOLIC_LINK : (Translatable)DescriptionPathAssertion.A_UNKNOWN_FILE_TYPE));
    }

    private static final AssertionGroup hintForParentFailure(Path parent2, Assertion explanation) {
        return (AssertionGroup)((ExplanatoryGroup.FinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertions(((Descriptive.FinalStep)AssertionBuilderKt.getAssertionBuilder().getDescriptive().getFailing().withDescriptionAndRepresentation((Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_PARENT, (Object)parent2)).build(), (Assertion)(explanation instanceof AssertionGroup ? (AssertionGroup)explanation : (AssertionGroup)((ExplanatoryGroup.FinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertion(explanation)).build()))).build();
    }

    @NotNull
    public static final Assertion hintForAccessDenied(@NotNull Path path) {
        Assertion assertion2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ExplanatoryAssertion failureDueToAccessDeniedHint = (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Object)DescriptionPathAssertion.FAILURE_DUE_TO_ACCESS_DENIED).build();
        try {
            List<Assertion> hints = HintsKt.hintForOwnersAndPermissions(path);
            hints.add(0, (Assertion)failureDueToAccessDeniedHint);
            assertion2 = ((ExplanatoryGroup.FinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertions(hints)).build();
        }
        catch (IOException e) {
            assertion2 = (Assertion)failureDueToAccessDeniedHint;
        }
        return assertion2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Assertion> hintForOwnersAndPermissions(@NotNull Path path) {
        void $this$getFileAttributeView$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkedList<ExplanatoryAssertion> hintList = new LinkedList<ExplanatoryAssertion>();
        Path path2 = path;
        Object linkOptions$iv = new LinkOption[]{};
        boolean $i$f$getFileAttributeView = false;
        AclFileAttributeView aclView = Files.getFileAttributeView((Path)$this$getFileAttributeView$iv, AclFileAttributeView.class, Arrays.copyOf(linkOptions$iv, ((LinkOption[])linkOptions$iv).length));
        if (aclView != null) {
            String string = aclView.getOwner().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aclView.owner.name");
            hintList.add(HintsKt.hintForOwner(string));
            Collection collection = hintList;
            List<AclEntry> list = aclView.getAcl();
            Intrinsics.checkNotNullExpressionValue(list, (String)"aclView.acl");
            CollectionsKt.addAll((Collection)collection, (Object[])HintsKt.hintsForActualAclPermissions(list));
        } else {
            void $this$getFileAttributeView$iv2;
            linkOptions$iv = path;
            LinkOption[] linkOptions$iv2 = new LinkOption[]{};
            boolean $i$f$getFileAttributeView2 = false;
            PosixFileAttributeView posixView = Files.getFileAttributeView((Path)$this$getFileAttributeView$iv2, PosixFileAttributeView.class, Arrays.copyOf(linkOptions$iv2, linkOptions$iv2.length));
            if (posixView != null) {
                PosixFileAttributes posixAttributes = posixView.readAttributes();
                String string = posixAttributes.owner().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixAttributes.owner().name");
                String string2 = posixAttributes.group().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"posixAttributes.group().name");
                hintList.add(HintsKt.hintForOwnerAndGroup(string, string2));
                Set<PosixFilePermission> set = posixAttributes.permissions();
                Intrinsics.checkNotNullExpressionValue(set, (String)"posixAttributes.permissions()");
                hintList.add(HintsKt.hintForActualPosixPermissions(set));
            }
        }
        return hintList;
    }

    private static final ExplanatoryAssertion hintForOwner(String owner) {
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Translatable)DescriptionPathAssertion.HINT_OWNER, (Object)owner, new Object[0]).build();
    }

    private static final ExplanatoryAssertion hintForOwnerAndGroup(String owner, String group) {
        Object[] objectArray = new Object[]{group};
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Translatable)DescriptionPathAssertion.HINT_OWNER_AND_GROUP, (Object)owner, objectArray).build();
    }

    /*
     * WARNING - void declaration
     */
    private static final Assertion[] hintsForActualAclPermissions(List<AclEntry> acl) {
        Collection<ExplanatoryAssertion> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Assertion[] assertionArray = new Assertion[2];
        assertionArray[0] = AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Object)DescriptionPathAssertion.HINT_ACTUAL_ACL_PERMISSIONS).build();
        Iterable iterable = acl;
        AssertionsOption assertionsOption = AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType();
        int n = 1;
        Assertion[] assertionArray2 = assertionArray;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AclEntry aclEntry = (AclEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HintsKt.hintForAclEntry((AclEntry)p0));
        }
        collection = (List)destination$iv$iv;
        assertionArray2[n] = ((ExplanatoryGroup.FinalStep)assertionsOption.withAssertions((List)collection)).build();
        return assertionArray;
    }

    private static final ExplanatoryAssertion hintForAclEntry(AclEntry entry) {
        Explanatory.ExplanationOption explanationOption = AssertionBuilderKt.getAssertionBuilder().getExplanatory();
        AclEntryType aclEntryType = entry.type();
        String string = entry.principal().getName();
        Set<AclEntryPermission> set = entry.permissions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"entry.permissions()");
        return (ExplanatoryAssertion)explanationOption.withExplanation(aclEntryType + " " + string + ": " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null)).build();
    }

    private static final ExplanatoryAssertion hintForActualPosixPermissions(Set<? extends PosixFilePermission> filePermissions) {
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Translatable)DescriptionPathAssertion.HINT_ACTUAL_POSIX_PERMISSIONS, (Object)HintsKt.formatPosixPermissions(filePermissions), new Object[0]).build();
    }

    private static final StringBuilder formatPosixPermissions(Set<? extends PosixFilePermission> filePermissions) {
        StringBuilder permissionString = new StringBuilder(17);
        permissionString.append("u=").append((CharSequence)HintsKt.toPermissionString(filePermissions, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)).append(' ').append("g=").append((CharSequence)HintsKt.toPermissionString(filePermissions, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE)).append(' ').append("o=").append((CharSequence)HintsKt.toPermissionString(filePermissions, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE));
        return permissionString;
    }

    private static final StringBuilder toPermissionString(Set<? extends PosixFilePermission> permissions, PosixFilePermission readPermission, PosixFilePermission writePermission, PosixFilePermission executePermission) {
        StringBuilder result = new StringBuilder(3);
        if (permissions.contains((Object)readPermission)) {
            result.append('r');
        }
        if (permissions.contains((Object)writePermission)) {
            result.append('w');
        }
        if (permissions.contains((Object)executePermission)) {
            result.append('x');
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends Path> Assertion hintForExistsButMissingPermission(@NotNull T subject, @NotNull Translatable permissionName) {
        void $this$readAttributes$iv;
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
        Explanatory.ExplanationOption explanationOption = AssertionBuilderKt.getAssertionBuilder().getExplanatory();
        Translatable translatable = (Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_PERMISSION_FILE_TYPE_HINT;
        Object object = subject;
        LinkOption[] linkOptions$iv = new LinkOption[]{};
        boolean $i$f$readAttributes = false;
        BasicFileAttributes basicFileAttributes = Files.readAttributes((Path)$this$readAttributes$iv, BasicFileAttributes.class, Arrays.copyOf(linkOptions$iv, linkOptions$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(this, A::class.java, *linkOptions)");
        object = new Object[]{permissionName};
        return explanationOption.withExplanation(translatable, (Object)HintsKt.getFileType(basicFileAttributes), object).build();
    }

    private static final DescriptiveAssertion describeWas(Translatable actual) {
        return (DescriptiveAssertion)((Descriptive.FinalStep)AssertionBuilderKt.getAssertionBuilder().getDescriptive().getFailing().withDescriptionAndRepresentation((Translatable)DescriptionBasic.WAS, (Object)actual)).build();
    }

    private static final Assertion hintForFileSpecificIoException(AssertionContainer<?> $this$hintForFileSpecificIoException, Path path, IOException exception) {
        return exception instanceof AccessDeniedException ? HintsKt.hintForAccessDenied(path) : (Assertion)HintsKt.hintForOtherIoException($this$hintForFileSpecificIoException, exception);
    }

    private static final AssertionGroup hintForFileNotFound(Path path) {
        return (AssertionGroup)((ExplanatoryGroup.FinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertions((Assertion)HintsKt.hintForNoSuchFile(), HintsKt.hintForClosestExistingParent(path))).build();
    }

    private static final ExplanatoryAssertion hintForNoSuchFile() {
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Object)DescriptionPathAssertion.FAILURE_DUE_TO_NO_SUCH_FILE).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Assertion hintForClosestExistingParent(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path testPath = path.toAbsolutePath().getParent();
        while (testPath.getNameCount() > 0) {
            try {
                Assertion assertion2;
                void $this$readAttributes$iv;
                Path path2 = testPath;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"testPath");
                Path path3 = path2;
                LinkOption[] linkOptions$iv = new LinkOption[]{};
                boolean $i$f$readAttributes = false;
                BasicFileAttributes basicFileAttributes = Files.readAttributes((Path)$this$readAttributes$iv, BasicFileAttributes.class, Arrays.copyOf(linkOptions$iv, linkOptions$iv.length));
                Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(this, A::class.java, *linkOptions)");
                BasicFileAttributes testPathAttributes = basicFileAttributes;
                if (testPathAttributes.isDirectory()) {
                    assertion2 = (Assertion)HintsKt.hintForExistingParentDirectory(testPath);
                } else {
                    Path path4 = testPath;
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"testPath");
                    assertion2 = (Assertion)HintsKt.hintForParentFailure(path4, (Assertion)HintsKt.hintForNotDirectory(HintsKt.getFileType(testPathAttributes)));
                }
                return assertion2;
            }
            catch (NoSuchFileException noSuchFileException) {
                testPath = testPath.getParent();
            }
        }
        return (Assertion)HintsKt.hintForExistingParentDirectory(null);
    }

    private static final ExplanatoryAssertion hintForExistingParentDirectory(Path parent2) {
        Path path = parent2;
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Translatable)DescriptionPathAssertion.HINT_CLOSEST_EXISTING_PARENT_DIRECTORY, (Object)(path != null ? (Comparable)path : (Comparable)DescriptionBasic.NONE), new Object[0]).build();
    }

    private static final ExplanatoryAssertion hintForNotDirectory(Translatable actualType) {
        Object[] objectArray = new Object[]{DescriptionPathAssertion.A_DIRECTORY};
        return (ExplanatoryAssertion)AssertionBuilderKt.getAssertionBuilder().getExplanatory().withExplanation((Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_WRONG_FILE_TYPE, (Object)actualType, objectArray).build();
    }

    private static final AssertionGroup hintForOtherIoException(AssertionContainer<?> $this$hintForOtherIoException, IOException exception) {
        Throwable throwable = exception;
        Explanatory.ExplanationOption explanationOption = AssertionBuilderKt.getAssertionBuilder().getExplanatory();
        Translatable translatable = (Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_ACCESS_EXCEPTION;
        String string = Reflection.getOrCreateKotlinClass(exception.getClass()).getSimpleName();
        if (string == null) {
            string = KClassExtensionsKt.getFullName((KClass)Reflection.getOrCreateKotlinClass(exception.getClass()));
        }
        return ThrowableThrownFailureHandler.Companion.propertiesOfThrowable(throwable, $this$hintForOtherIoException, explanationOption.withExplanation(translatable, (Object)string, new Object[0]).build());
    }

    public static final /* synthetic */ DescriptiveAssertion access$describeWas(Translatable actual) {
        return HintsKt.describeWas(actual);
    }

    public static final /* synthetic */ Translatable access$getFileType(BasicFileAttributes $receiver) {
        return HintsKt.getFileType($receiver);
    }
}

