/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.logic.impl;

import ch.tutteli.atrium.assertions.Assertion;
import ch.tutteli.atrium.creating.AssertionContainer;
import ch.tutteli.atrium.logic.ChronoLocalDateAssertions;
import ch.tutteli.atrium.logic.ChronoLocalDateKt;
import ch.tutteli.atrium.logic.UtilsKt;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.translations.DescriptionDateTimeLikeExpectation;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J(\u0010\u000b\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\f\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J(\u0010\f\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J(\u0010\r\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J(\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lch/tutteli/atrium/logic/impl/DefaultChronoLocalDateAssertions;", "Lch/tutteli/atrium/logic/ChronoLocalDateAssertions;", "()V", "isAfter", "Lch/tutteli/atrium/assertions/Assertion;", "T", "Ljava/time/chrono/ChronoLocalDate;", "container", "Lch/tutteli/atrium/creating/AssertionContainer;", "expected", "", "isAfterOrEqual", "isBefore", "isBeforeOrEqual", "isEqual", "atrium-logic"})
public final class DefaultChronoLocalDateAssertions
implements ChronoLocalDateAssertions {
    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDate expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDate $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDate expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDate $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDate expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDate $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDate expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDate $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDate expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_THE_SAME_DAY_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDate $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        LocalDate localDate = LocalDate.parse(expected);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(expected)");
        return ChronoLocalDateKt.isBefore(container, localDate);
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        LocalDate localDate = LocalDate.parse(expected);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(expected)");
        return ChronoLocalDateKt.isBeforeOrEqual(container, localDate);
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        LocalDate localDate = LocalDate.parse(expected);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(expected)");
        return ChronoLocalDateKt.isAfter(container, localDate);
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        LocalDate localDate = LocalDate.parse(expected);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(expected)");
        return ChronoLocalDateKt.isAfterOrEqual(container, localDate);
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDate> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        LocalDate localDate = LocalDate.parse(expected);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(expected)");
        return ChronoLocalDateKt.isEqual(container, localDate);
    }
}

