/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.logic.impl;

import ch.tutteli.atrium.assertions.Assertion;
import ch.tutteli.atrium.creating.AssertionContainer;
import ch.tutteli.atrium.logic.ChronoLocalDateTimeAssertions;
import ch.tutteli.atrium.logic.ChronoLocalDateTimeKt;
import ch.tutteli.atrium.logic.UtilsKt;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.translations.DescriptionDateTimeLikeExpectation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u0003\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\r\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\r\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\u000e\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u000e\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\u000f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u000f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lch/tutteli/atrium/logic/impl/DefaultChronoLocalDateTimeAssertions;", "Lch/tutteli/atrium/logic/ChronoLocalDateTimeAssertions;", "()V", "isAfter", "Lch/tutteli/atrium/assertions/Assertion;", "T", "Ljava/time/chrono/ChronoLocalDateTime;", "Ljava/time/chrono/ChronoLocalDate;", "container", "Lch/tutteli/atrium/creating/AssertionContainer;", "expected", "", "isAfterOrEqual", "isBefore", "isBeforeOrEqual", "isEqual", "stringToLocalDateTime", "Ljava/time/LocalDateTime;", "data", "atrium-logic"})
public final class DefaultChronoLocalDateTimeAssertions
implements ChronoLocalDateTimeAssertions {
    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoLocalDateTimeKt.isBefore(container, this.stringToLocalDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoLocalDateTimeKt.isBeforeOrEqual(container, this.stringToLocalDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoLocalDateTimeKt.isAfter(container, this.stringToLocalDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoLocalDateTimeKt.isAfterOrEqual(container, this.stringToLocalDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoLocalDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoLocalDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoLocalDateTime<? extends ChronoLocalDate>> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoLocalDateTimeKt.isEqual(container, this.stringToLocalDateTime(expected));
    }

    private final LocalDateTime stringToLocalDateTime(String data) {
        LocalDateTime localDateTime;
        if (StringsKt.contains$default((CharSequence)data, (CharSequence)"T", (boolean)false, (int)2, null)) {
            LocalDateTime localDateTime2 = LocalDateTime.parse(data);
            localDateTime = localDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"{\n            LocalDateTime.parse(data)\n        }");
        } else {
            LocalDateTime localDateTime3 = LocalDate.parse(data).atStartOfDay();
            localDateTime = localDateTime3;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"{\n            LocalDate.\u2026.atStartOfDay()\n        }");
        }
        return localDateTime;
    }
}

