/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.logic.impl;

import ch.tutteli.atrium.assertions.Assertion;
import ch.tutteli.atrium.creating.AssertionContainer;
import ch.tutteli.atrium.logic.ChronoZonedDateTimeAssertions;
import ch.tutteli.atrium.logic.ChronoZonedDateTimeKt;
import ch.tutteli.atrium.logic.UtilsKt;
import ch.tutteli.atrium.logic.impl.DefaultChronoZonedDateTimeAssertions;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.translations.DescriptionDateTimeLikeExpectation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u0003\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\r\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\r\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\u000e\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u000e\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\u000f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J0\u0010\u000f\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lch/tutteli/atrium/logic/impl/DefaultChronoZonedDateTimeAssertions;", "Lch/tutteli/atrium/logic/ChronoZonedDateTimeAssertions;", "()V", "isAfter", "Lch/tutteli/atrium/assertions/Assertion;", "T", "Ljava/time/chrono/ChronoZonedDateTime;", "Ljava/time/chrono/ChronoLocalDate;", "container", "Lch/tutteli/atrium/creating/AssertionContainer;", "expected", "", "isAfterOrEqual", "isBefore", "isBeforeOrEqual", "isEqual", "parseZonedDateTime", "Ljava/time/ZonedDateTime;", "data", "atrium-logic"})
public final class DefaultChronoZonedDateTimeAssertions
implements ChronoZonedDateTimeAssertions {
    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull ChronoZonedDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoZonedDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoZonedDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_BEFORE_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoZonedDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isBefore(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull ChronoZonedDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoZonedDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoZonedDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_AFTER_OR_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoZonedDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isAfter(this.$expected) || it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull ChronoZonedDateTime<?> expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return UtilsKt.createDescriptiveAssertion(container, (Translatable)DescriptionDateTimeLikeExpectation.TO_BE_THE_SAME_POINT_IN_TIME_AS, expected, (Function1)new Function1<T, Boolean>(expected){
            final /* synthetic */ ChronoZonedDateTime<?> $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.isEqual(this.$expected);
            }
        });
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isBefore(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoZonedDateTimeKt.isBefore(container, this.parseZonedDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isBeforeOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoZonedDateTimeKt.isBeforeOrEqual(container, this.parseZonedDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isAfter(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoZonedDateTimeKt.isAfter(container, this.parseZonedDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isAfterOrEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoZonedDateTimeKt.isAfterOrEqual(container, this.parseZonedDateTime(expected));
    }

    @Override
    @NotNull
    public <T extends ChronoZonedDateTime<? extends ChronoLocalDate>> Assertion isEqual(@NotNull AssertionContainer<T> container, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return ChronoZonedDateTimeKt.isEqual(container, this.parseZonedDateTime(expected));
    }

    private final ZonedDateTime parseZonedDateTime(String data) {
        ZonedDateTime zonedDateTime;
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseSensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().appendOffsetId().toFormatter();
        Object object = new TemporalQuery[]{parseZonedDateTime.parsed.1.INSTANCE, parseZonedDateTime.parsed.2.INSTANCE, parseZonedDateTime.parsed.3.INSTANCE};
        TemporalAccessor parsed2 = formatter.parseBest(data, (TemporalQuery<?>)object);
        if ((object = parsed2) instanceof LocalDate) {
            List parts;
            String[] stringArray;
            ZonedDateTime zonedDateTime2;
            if (StringsKt.contains$default((CharSequence)data, (CharSequence)"Z", (boolean)false, (int)2, null)) {
                zonedDateTime2 = ((LocalDate)parsed2).atStartOfDay(ZoneOffset.UTC);
            } else if (StringsKt.contains$default((CharSequence)data, (CharSequence)"+", (boolean)false, (int)2, null)) {
                stringArray = new String[]{"+"};
                parts = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                zonedDateTime2 = ((LocalDate)parsed2).atStartOfDay(ZoneOffset.of("+" + CollectionsKt.last((List)parts)));
            } else if (StringsKt.contains$default((CharSequence)data, (CharSequence)"-", (boolean)false, (int)2, null)) {
                stringArray = new String[]{"-"};
                parts = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                zonedDateTime2 = ((LocalDate)parsed2).atStartOfDay(ZoneOffset.of("-" + CollectionsKt.last((List)parts)));
            } else {
                zonedDateTime2 = ZonedDateTime.parse(data);
            }
            ZonedDateTime zonedDateTime3 = zonedDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"{\n                when {\u2026          }\n            }");
            zonedDateTime = zonedDateTime3;
        } else if (object instanceof LocalDateTime) {
            ZonedDateTime zonedDateTime4 = ((LocalDateTime)parsed2).atZone(ZoneOffset.UTC);
            zonedDateTime = zonedDateTime4;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"parsed.atZone(ZoneOffset.UTC)");
        } else if (object instanceof ZonedDateTime) {
            Intrinsics.checkNotNullExpressionValue((Object)parsed2, (String)"parsed");
            zonedDateTime = (ZonedDateTime)parsed2;
        } else {
            ZonedDateTime zonedDateTime5 = ZonedDateTime.parse(data);
            zonedDateTime = zonedDateTime5;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"parse(data)");
        }
        return zonedDateTime;
    }
}

