/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostSpec {
    public static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*|[::1]|0.0.0.0|[::0]";
    protected final String _host;
    protected final int port;

    public HostSpec(String _host, int port) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._host = _host;
        this.port = port;
    }

    public String getHost() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._host;
    }

    public int getPort() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.port;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._host + ":" + this.port;
    }

    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return objt instanceof HostSpec && this.port == ((HostSpec)objt).port && this._host.equals(((HostSpec)objt)._host);
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.port ^ this._host.hashCode();
    }

    public Boolean shouldResolve() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String socksProxyHost = System.getProperty("socksProxyHost");
        if (socksProxyHost == null || socksProxyHost.trim().isEmpty()) {
            return true;
        }
        return this.matchesNonProxyHosts();
    }

    private Boolean matchesNonProxyHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String nonProxyHosts = System.getProperty("socksNonProxyHosts", DEFAULT_NON_PROXY_HOSTS);
        if (nonProxyHosts == null || this._host.isEmpty()) {
            return false;
        }
        Pattern pat = this.toPattern(nonProxyHosts);
        Matcher matcher = pat == null ? null : pat.matcher(this._host);
        return matcher != null && matcher.matches();
    }

    private Pattern toPattern(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder joiner = new StringBuilder();
        String separator = "";
        for (String disjunct : str.split("\\|")) {
            if (disjunct.isEmpty()) continue;
            String reg = this.disjunctToRegex(disjunct.toLowerCase());
            joiner.append(separator).append(reg);
            separator = "|";
        }
        return joiner.length() == 0 ? null : Pattern.compile(joiner.toString());
    }

    private String disjunctToRegex(String disjunct) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String reg = disjunct.startsWith("*") ? ".*" + Pattern.quote(disjunct.substring(1)) : (disjunct.endsWith("*") ? Pattern.quote(disjunct.substring(0, disjunct.length() - 1)) + ".*" : Pattern.quote(disjunct));
        return reg;
    }
}

