/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.json.JSON;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import cn.hutool.json.serialize.TemporalAccessorSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalSerializeMapping {
    private static Map<Type, JSONSerializer<? extends JSON, ?>> serializerMap = new SafeConcurrentHashMap();
    private static Map<Type, JSONDeserializer<?>> deserializerMap = new SafeConcurrentHashMap();

    public static void put(Type type, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    public static void put(Type type, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    private static synchronized void putInternal(Type type, JSONSerializer<? extends JSON, ?> serializer) {
        if (null == serializerMap) {
            serializerMap = new SafeConcurrentHashMap();
        }
        serializerMap.put(type, serializer);
    }

    public static synchronized void put(Type type, JSONDeserializer<?> deserializer) {
        if (null == deserializerMap) {
            deserializerMap = new ConcurrentHashMap();
        }
        deserializerMap.put(type, deserializer);
    }

    public static JSONSerializer<? extends JSON, ?> getSerializer(Type type) {
        if (null == type || null == serializerMap) {
            return null;
        }
        return serializerMap.get(type);
    }

    public static JSONDeserializer<?> getDeserializer(Type type) {
        if (null == type || null == deserializerMap) {
            return null;
        }
        return deserializerMap.get(type);
    }

    static {
        TemporalAccessorSerializer localDateSerializer = new TemporalAccessorSerializer(LocalDate.class);
        serializerMap.put((Type)((Object)LocalDate.class), localDateSerializer);
        deserializerMap.put((Type)((Object)LocalDate.class), localDateSerializer);
        TemporalAccessorSerializer localDateTimeSerializer = new TemporalAccessorSerializer(LocalDateTime.class);
        serializerMap.put((Type)((Object)LocalDateTime.class), localDateTimeSerializer);
        deserializerMap.put((Type)((Object)LocalDateTime.class), localDateTimeSerializer);
        TemporalAccessorSerializer localTimeSerializer = new TemporalAccessorSerializer(LocalTime.class);
        serializerMap.put((Type)((Object)LocalTime.class), localTimeSerializer);
        deserializerMap.put((Type)((Object)LocalTime.class), localTimeSerializer);
    }
}

