/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.metadata.holder.xlsx;

import cn.idev.excel.constant.BuiltinFormats;
import cn.idev.excel.metadata.data.DataFormatData;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.read.metadata.holder.ReadWorkbookHolder;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.util.MapUtils;
import java.util.Map;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class XlsxReadWorkbookHolder
extends ReadWorkbookHolder {
    private OPCPackage opcPackage;
    private String saxParserFactoryName;
    private StylesTable stylesTable;
    private Map<Integer, DataFormatData> dataFormatDataCache;
    private Map<Integer, PackageRelationshipCollection> packageRelationshipCollectionMap;

    public XlsxReadWorkbookHolder(ReadWorkbook readWorkbook) {
        super(readWorkbook);
        this.saxParserFactoryName = readWorkbook.getXlsxSAXParserFactoryName();
        this.setExcelType(ExcelTypeEnum.XLSX);
        this.dataFormatDataCache = MapUtils.newHashMap();
    }

    public DataFormatData dataFormatData(int dateFormatIndexInteger) {
        return this.dataFormatDataCache.computeIfAbsent(dateFormatIndexInteger, key -> {
            DataFormatData dataFormatData = new DataFormatData();
            if (this.stylesTable == null) {
                return null;
            }
            XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(dateFormatIndexInteger);
            if (xssfCellStyle == null) {
                return null;
            }
            dataFormatData.setIndex(xssfCellStyle.getDataFormat());
            dataFormatData.setFormat(BuiltinFormats.getBuiltinFormat(dataFormatData.getIndex(), xssfCellStyle.getDataFormatString(), this.globalConfiguration().getLocale()));
            return dataFormatData;
        });
    }

    public OPCPackage getOpcPackage() {
        return this.opcPackage;
    }

    public String getSaxParserFactoryName() {
        return this.saxParserFactoryName;
    }

    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    public Map<Integer, DataFormatData> getDataFormatDataCache() {
        return this.dataFormatDataCache;
    }

    public Map<Integer, PackageRelationshipCollection> getPackageRelationshipCollectionMap() {
        return this.packageRelationshipCollectionMap;
    }

    public void setOpcPackage(OPCPackage opcPackage) {
        this.opcPackage = opcPackage;
    }

    public void setSaxParserFactoryName(String saxParserFactoryName) {
        this.saxParserFactoryName = saxParserFactoryName;
    }

    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public void setDataFormatDataCache(Map<Integer, DataFormatData> dataFormatDataCache) {
        this.dataFormatDataCache = dataFormatDataCache;
    }

    public void setPackageRelationshipCollectionMap(Map<Integer, PackageRelationshipCollection> packageRelationshipCollectionMap) {
        this.packageRelationshipCollectionMap = packageRelationshipCollectionMap;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XlsxReadWorkbookHolder)) {
            return false;
        }
        XlsxReadWorkbookHolder other = (XlsxReadWorkbookHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OPCPackage this$opcPackage = this.getOpcPackage();
        OPCPackage other$opcPackage = other.getOpcPackage();
        if (this$opcPackage == null ? other$opcPackage != null : !this$opcPackage.equals(other$opcPackage)) {
            return false;
        }
        String this$saxParserFactoryName = this.getSaxParserFactoryName();
        String other$saxParserFactoryName = other.getSaxParserFactoryName();
        if (this$saxParserFactoryName == null ? other$saxParserFactoryName != null : !this$saxParserFactoryName.equals(other$saxParserFactoryName)) {
            return false;
        }
        StylesTable this$stylesTable = this.getStylesTable();
        StylesTable other$stylesTable = other.getStylesTable();
        if (this$stylesTable == null ? other$stylesTable != null : !this$stylesTable.equals(other$stylesTable)) {
            return false;
        }
        Map<Integer, DataFormatData> this$dataFormatDataCache = this.getDataFormatDataCache();
        Map<Integer, DataFormatData> other$dataFormatDataCache = other.getDataFormatDataCache();
        if (this$dataFormatDataCache == null ? other$dataFormatDataCache != null : !((Object)this$dataFormatDataCache).equals(other$dataFormatDataCache)) {
            return false;
        }
        Map<Integer, PackageRelationshipCollection> this$packageRelationshipCollectionMap = this.getPackageRelationshipCollectionMap();
        Map<Integer, PackageRelationshipCollection> other$packageRelationshipCollectionMap = other.getPackageRelationshipCollectionMap();
        return !(this$packageRelationshipCollectionMap == null ? other$packageRelationshipCollectionMap != null : !((Object)this$packageRelationshipCollectionMap).equals(other$packageRelationshipCollectionMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XlsxReadWorkbookHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OPCPackage $opcPackage = this.getOpcPackage();
        result = result * 59 + ($opcPackage == null ? 43 : $opcPackage.hashCode());
        String $saxParserFactoryName = this.getSaxParserFactoryName();
        result = result * 59 + ($saxParserFactoryName == null ? 43 : $saxParserFactoryName.hashCode());
        StylesTable $stylesTable = this.getStylesTable();
        result = result * 59 + ($stylesTable == null ? 43 : $stylesTable.hashCode());
        Map<Integer, DataFormatData> $dataFormatDataCache = this.getDataFormatDataCache();
        result = result * 59 + ($dataFormatDataCache == null ? 43 : ((Object)$dataFormatDataCache).hashCode());
        Map<Integer, PackageRelationshipCollection> $packageRelationshipCollectionMap = this.getPackageRelationshipCollectionMap();
        result = result * 59 + ($packageRelationshipCollectionMap == null ? 43 : ((Object)$packageRelationshipCollectionMap).hashCode());
        return result;
    }
}

