/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.format.DataFormatter;
import java.math.BigDecimal;
import java.util.Locale;

public class NumberDataFormatterUtils {
    private static final ThreadLocal<DataFormatter> DATA_FORMATTER_THREAD_LOCAL = new ThreadLocal();

    public static String format(BigDecimal data, Short dataFormat, String dataFormatString, GlobalConfiguration globalConfiguration) {
        if (globalConfiguration == null) {
            return NumberDataFormatterUtils.format(data, dataFormat, dataFormatString, null, null, null);
        }
        return NumberDataFormatterUtils.format(data, dataFormat, dataFormatString, globalConfiguration.getUse1904windowing(), globalConfiguration.getLocale(), globalConfiguration.getUseScientificFormat());
    }

    public static String format(BigDecimal data, Short dataFormat, String dataFormatString, Boolean use1904windowing, Locale locale, Boolean useScientificFormat) {
        DataFormatter dataFormatter = DATA_FORMATTER_THREAD_LOCAL.get();
        if (dataFormatter == null) {
            dataFormatter = new DataFormatter(use1904windowing, locale, useScientificFormat);
            DATA_FORMATTER_THREAD_LOCAL.set(dataFormatter);
        }
        return dataFormatter.format(data, dataFormat, dataFormatString);
    }

    public static void removeThreadLocalCache() {
        DATA_FORMATTER_THREAD_LOCAL.remove();
    }
}

