/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.metadata.holder;

import cn.idev.excel.constant.OrderConstant;
import cn.idev.excel.converters.Converter;
import cn.idev.excel.converters.ConverterKeyBuild;
import cn.idev.excel.converters.DefaultConverterLoader;
import cn.idev.excel.enums.HeadKindEnum;
import cn.idev.excel.event.NotRepeatExecutor;
import cn.idev.excel.metadata.AbstractHolder;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.idev.excel.metadata.property.LoopMergeProperty;
import cn.idev.excel.metadata.property.OnceAbsoluteMergeProperty;
import cn.idev.excel.metadata.property.RowHeightProperty;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.handler.DefaultWriteHandlerLoader;
import cn.idev.excel.write.handler.RowWriteHandler;
import cn.idev.excel.write.handler.SheetWriteHandler;
import cn.idev.excel.write.handler.WorkbookWriteHandler;
import cn.idev.excel.write.handler.WriteHandler;
import cn.idev.excel.write.handler.chain.CellHandlerExecutionChain;
import cn.idev.excel.write.handler.chain.RowHandlerExecutionChain;
import cn.idev.excel.write.handler.chain.SheetHandlerExecutionChain;
import cn.idev.excel.write.handler.chain.WorkbookHandlerExecutionChain;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.merge.LoopMergeStrategy;
import cn.idev.excel.write.merge.OnceAbsoluteMergeStrategy;
import cn.idev.excel.write.metadata.WriteBasicParameter;
import cn.idev.excel.write.metadata.holder.WriteHolder;
import cn.idev.excel.write.metadata.holder.WriteWorkbookHolder;
import cn.idev.excel.write.metadata.style.WriteCellStyle;
import cn.idev.excel.write.property.ExcelWriteHeadProperty;
import cn.idev.excel.write.style.AbstractVerticalCellStyleStrategy;
import cn.idev.excel.write.style.column.AbstractHeadColumnWidthStyleStrategy;
import cn.idev.excel.write.style.row.SimpleRowHeightStyleStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractWriteHolder
extends AbstractHolder
implements WriteHolder {
    private Boolean needHead;
    private Integer relativeHeadRowIndex;
    private ExcelWriteHeadProperty excelWriteHeadProperty;
    private Boolean useDefaultStyle;
    private Boolean automaticMergeHead;
    private Collection<Integer> excludeColumnIndexes;
    private Collection<String> excludeColumnFieldNames;
    private Collection<Integer> includeColumnIndexes;
    private Collection<String> includeColumnFieldNames;
    private Boolean orderByIncludeColumn;
    private List<WriteHandler> writeHandlerList;
    public WorkbookHandlerExecutionChain ownWorkbookHandlerExecutionChain;
    public SheetHandlerExecutionChain ownSheetHandlerExecutionChain;
    public WorkbookHandlerExecutionChain workbookHandlerExecutionChain;
    public SheetHandlerExecutionChain sheetHandlerExecutionChain;
    public RowHandlerExecutionChain rowHandlerExecutionChain;
    public CellHandlerExecutionChain cellHandlerExecutionChain;

    public AbstractWriteHolder(WriteBasicParameter writeBasicParameter, AbstractWriteHolder parentAbstractWriteHolder) {
        super(writeBasicParameter, parentAbstractWriteHolder);
        if (writeBasicParameter.getUseScientificFormat() != null) {
            throw new UnsupportedOperationException("Currently does not support setting useScientificFormat.");
        }
        this.needHead = writeBasicParameter.getNeedHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getNeedHead()) : writeBasicParameter.getNeedHead();
        this.relativeHeadRowIndex = writeBasicParameter.getRelativeHeadRowIndex() == null ? (parentAbstractWriteHolder == null ? Integer.valueOf(0) : parentAbstractWriteHolder.getRelativeHeadRowIndex()) : writeBasicParameter.getRelativeHeadRowIndex();
        this.useDefaultStyle = writeBasicParameter.getUseDefaultStyle() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getUseDefaultStyle()) : writeBasicParameter.getUseDefaultStyle();
        this.automaticMergeHead = writeBasicParameter.getAutomaticMergeHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getAutomaticMergeHead()) : writeBasicParameter.getAutomaticMergeHead();
        this.excludeColumnFieldNames = writeBasicParameter.getExcludeColumnFieldNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnFieldNames() : writeBasicParameter.getExcludeColumnFieldNames();
        this.excludeColumnIndexes = writeBasicParameter.getExcludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnIndexes() : writeBasicParameter.getExcludeColumnIndexes();
        this.includeColumnFieldNames = writeBasicParameter.getIncludeColumnFieldNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnFieldNames() : writeBasicParameter.getIncludeColumnFieldNames();
        this.orderByIncludeColumn = writeBasicParameter.getOrderByIncludeColumn() == null ? (parentAbstractWriteHolder == null ? Boolean.FALSE : parentAbstractWriteHolder.getOrderByIncludeColumn()) : writeBasicParameter.getOrderByIncludeColumn();
        this.includeColumnIndexes = writeBasicParameter.getIncludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnIndexes() : writeBasicParameter.getIncludeColumnIndexes();
        this.excelWriteHeadProperty = new ExcelWriteHeadProperty(this, this.getClazz(), this.getHead());
        if (parentAbstractWriteHolder == null) {
            this.setConverterMap(DefaultConverterLoader.loadDefaultWriteConverter());
        } else {
            this.setConverterMap(new HashMap(parentAbstractWriteHolder.getConverterMap()));
        }
        if (writeBasicParameter.getCustomConverterList() != null && !writeBasicParameter.getCustomConverterList().isEmpty()) {
            for (Converter<?> converter : writeBasicParameter.getCustomConverterList()) {
                this.getConverterMap().put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
            }
        }
    }

    protected void initHandler(WriteBasicParameter writeBasicParameter, AbstractWriteHolder parentAbstractWriteHolder) {
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        this.initAnnotationConfig(handlerList, writeBasicParameter);
        if (writeBasicParameter.getCustomWriteHandlerList() != null && !writeBasicParameter.getCustomWriteHandlerList().isEmpty()) {
            handlerList.addAll(writeBasicParameter.getCustomWriteHandlerList());
        }
        this.sortAndClearUpHandler(handlerList, true);
        if (parentAbstractWriteHolder != null) {
            if (CollectionUtils.isNotEmpty(parentAbstractWriteHolder.getWriteHandlerList())) {
                handlerList.addAll(parentAbstractWriteHolder.getWriteHandlerList());
            }
        } else if (this instanceof WriteWorkbookHolder) {
            handlerList.addAll(DefaultWriteHandlerLoader.loadDefaultHandler(this.useDefaultStyle, ((WriteWorkbookHolder)this).getExcelType()));
        }
        this.sortAndClearUpHandler(handlerList, false);
    }

    protected void initAnnotationConfig(List<WriteHandler> handlerList, WriteBasicParameter writeBasicParameter) {
        if (!HeadKindEnum.CLASS.equals((Object)this.getExcelWriteHeadProperty().getHeadKind())) {
            return;
        }
        if (writeBasicParameter.getClazz() == null) {
            return;
        }
        Map<Integer, Head> headMap = this.getExcelWriteHeadProperty().getHeadMap();
        boolean hasColumnWidth = false;
        for (Head head : headMap.values()) {
            if (head.getColumnWidthProperty() != null) {
                hasColumnWidth = true;
            }
            this.dealLoopMerge(handlerList, head);
        }
        if (hasColumnWidth) {
            this.dealColumnWidth(handlerList);
        }
        this.dealStyle(handlerList);
        this.dealRowHigh(handlerList);
        this.dealOnceAbsoluteMerge(handlerList);
    }

    private void dealStyle(List<WriteHandler> handlerList) {
        AbstractVerticalCellStyleStrategy styleStrategy = new AbstractVerticalCellStyleStrategy(){

            @Override
            public int order() {
                return OrderConstant.ANNOTATION_DEFINE_STYLE;
            }

            @Override
            protected WriteCellStyle headCellStyle(CellWriteHandlerContext context) {
                Head head = context.getHeadData();
                if (head == null) {
                    return null;
                }
                return WriteCellStyle.build(head.getHeadStyleProperty(), head.getHeadFontProperty());
            }

            @Override
            protected WriteCellStyle contentCellStyle(CellWriteHandlerContext context) {
                ExcelContentProperty excelContentProperty = context.getExcelContentProperty();
                return WriteCellStyle.build(excelContentProperty.getContentStyleProperty(), excelContentProperty.getContentFontProperty());
            }
        };
        handlerList.add(styleStrategy);
    }

    private void dealLoopMerge(List<WriteHandler> handlerList, Head head) {
        LoopMergeProperty loopMergeProperty = head.getLoopMergeProperty();
        if (loopMergeProperty == null) {
            return;
        }
        handlerList.add(new LoopMergeStrategy(loopMergeProperty, head.getColumnIndex()));
    }

    private void dealOnceAbsoluteMerge(List<WriteHandler> handlerList) {
        OnceAbsoluteMergeProperty onceAbsoluteMergeProperty = this.getExcelWriteHeadProperty().getOnceAbsoluteMergeProperty();
        if (onceAbsoluteMergeProperty == null) {
            return;
        }
        handlerList.add(new OnceAbsoluteMergeStrategy(onceAbsoluteMergeProperty));
    }

    private void dealRowHigh(List<WriteHandler> handlerList) {
        RowHeightProperty headRowHeightProperty = this.getExcelWriteHeadProperty().getHeadRowHeightProperty();
        RowHeightProperty contentRowHeightProperty = this.getExcelWriteHeadProperty().getContentRowHeightProperty();
        if (headRowHeightProperty == null && contentRowHeightProperty == null) {
            return;
        }
        Short headRowHeight = null;
        if (headRowHeightProperty != null) {
            headRowHeight = headRowHeightProperty.getHeight();
        }
        Short contentRowHeight = null;
        if (contentRowHeightProperty != null) {
            contentRowHeight = contentRowHeightProperty.getHeight();
        }
        handlerList.add(new SimpleRowHeightStyleStrategy(headRowHeight, contentRowHeight));
    }

    private void dealColumnWidth(List<WriteHandler> handlerList) {
        AbstractHeadColumnWidthStyleStrategy columnWidthStyleStrategy = new AbstractHeadColumnWidthStyleStrategy(){

            @Override
            protected Integer columnWidth(Head head, Integer columnIndex) {
                if (head == null) {
                    return null;
                }
                if (head.getColumnWidthProperty() != null) {
                    return head.getColumnWidthProperty().getWidth();
                }
                return null;
            }
        };
        handlerList.add(columnWidthStyleStrategy);
    }

    protected void sortAndClearUpHandler(List<WriteHandler> handlerList, boolean runOwn) {
        TreeMap orderExcelWriteHandlerMap = new TreeMap();
        for (WriteHandler handler : handlerList) {
            int order = handler.order();
            if (orderExcelWriteHandlerMap.containsKey(order)) {
                ((List)orderExcelWriteHandlerMap.get(order)).add(handler);
                continue;
            }
            ArrayList<WriteHandler> tempHandlerList = new ArrayList<WriteHandler>();
            tempHandlerList.add(handler);
            orderExcelWriteHandlerMap.put(order, tempHandlerList);
        }
        HashSet<String> alreadyExistedHandlerSet = new HashSet<String>();
        ArrayList<WriteHandler> cleanUpHandlerList = new ArrayList<WriteHandler>();
        for (Map.Entry entry : orderExcelWriteHandlerMap.entrySet()) {
            for (WriteHandler handler : (List)entry.getValue()) {
                if (handler instanceof NotRepeatExecutor) {
                    String uniqueValue = ((NotRepeatExecutor)((Object)handler)).uniqueValue();
                    if (alreadyExistedHandlerSet.contains(uniqueValue)) continue;
                    alreadyExistedHandlerSet.add(uniqueValue);
                }
                cleanUpHandlerList.add(handler);
            }
        }
        if (!runOwn) {
            this.writeHandlerList = new ArrayList<WriteHandler>();
        }
        for (WriteHandler writeHandler : cleanUpHandlerList) {
            this.buildChain(writeHandler, runOwn);
        }
    }

    protected void buildChain(WriteHandler writeHandler, boolean runOwn) {
        if (writeHandler instanceof CellWriteHandler && !runOwn) {
            if (this.cellHandlerExecutionChain == null) {
                this.cellHandlerExecutionChain = new CellHandlerExecutionChain((CellWriteHandler)writeHandler);
            } else {
                this.cellHandlerExecutionChain.addLast((CellWriteHandler)writeHandler);
            }
        }
        if (writeHandler instanceof RowWriteHandler && !runOwn) {
            if (this.rowHandlerExecutionChain == null) {
                this.rowHandlerExecutionChain = new RowHandlerExecutionChain((RowWriteHandler)writeHandler);
            } else {
                this.rowHandlerExecutionChain.addLast((RowWriteHandler)writeHandler);
            }
        }
        if (writeHandler instanceof SheetWriteHandler) {
            if (!runOwn) {
                if (this.sheetHandlerExecutionChain == null) {
                    this.sheetHandlerExecutionChain = new SheetHandlerExecutionChain((SheetWriteHandler)writeHandler);
                } else {
                    this.sheetHandlerExecutionChain.addLast((SheetWriteHandler)writeHandler);
                }
            } else if (this.ownSheetHandlerExecutionChain == null) {
                this.ownSheetHandlerExecutionChain = new SheetHandlerExecutionChain((SheetWriteHandler)writeHandler);
            } else {
                this.ownSheetHandlerExecutionChain.addLast((SheetWriteHandler)writeHandler);
            }
        }
        if (writeHandler instanceof WorkbookWriteHandler) {
            if (!runOwn) {
                if (this.workbookHandlerExecutionChain == null) {
                    this.workbookHandlerExecutionChain = new WorkbookHandlerExecutionChain((WorkbookWriteHandler)writeHandler);
                } else {
                    this.workbookHandlerExecutionChain.addLast((WorkbookWriteHandler)writeHandler);
                }
            } else if (this.ownWorkbookHandlerExecutionChain == null) {
                this.ownWorkbookHandlerExecutionChain = new WorkbookHandlerExecutionChain((WorkbookWriteHandler)writeHandler);
            } else {
                this.ownWorkbookHandlerExecutionChain.addLast((WorkbookWriteHandler)writeHandler);
            }
        }
        if (!runOwn) {
            this.writeHandlerList.add(writeHandler);
        }
    }

    @Override
    public boolean ignore(String fieldName, Integer columnIndex) {
        if (fieldName != null) {
            if (this.includeColumnFieldNames != null && !this.includeColumnFieldNames.contains(fieldName)) {
                return true;
            }
            if (this.excludeColumnFieldNames != null && this.excludeColumnFieldNames.contains(fieldName)) {
                return true;
            }
        }
        if (columnIndex != null) {
            if (this.includeColumnIndexes != null && !this.includeColumnIndexes.contains(columnIndex)) {
                return true;
            }
            if (this.excludeColumnIndexes != null && this.excludeColumnIndexes.contains(columnIndex)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ExcelWriteHeadProperty excelWriteHeadProperty() {
        return this.getExcelWriteHeadProperty();
    }

    @Override
    public boolean needHead() {
        return this.getNeedHead();
    }

    @Override
    public int relativeHeadRowIndex() {
        return this.getRelativeHeadRowIndex();
    }

    @Override
    public boolean automaticMergeHead() {
        return this.getAutomaticMergeHead();
    }

    @Override
    public boolean orderByIncludeColumn() {
        return this.getOrderByIncludeColumn();
    }

    @Override
    public Collection<Integer> includeColumnIndexes() {
        return this.getIncludeColumnIndexes();
    }

    @Override
    public Collection<String> includeColumnFieldNames() {
        return this.getIncludeColumnFieldNames();
    }

    @Override
    public Collection<Integer> excludeColumnIndexes() {
        return this.getExcludeColumnIndexes();
    }

    @Override
    public Collection<String> excludeColumnFieldNames() {
        return this.getExcludeColumnFieldNames();
    }

    public Boolean getNeedHead() {
        return this.needHead;
    }

    public Integer getRelativeHeadRowIndex() {
        return this.relativeHeadRowIndex;
    }

    public ExcelWriteHeadProperty getExcelWriteHeadProperty() {
        return this.excelWriteHeadProperty;
    }

    public Boolean getUseDefaultStyle() {
        return this.useDefaultStyle;
    }

    public Boolean getAutomaticMergeHead() {
        return this.automaticMergeHead;
    }

    public Collection<Integer> getExcludeColumnIndexes() {
        return this.excludeColumnIndexes;
    }

    public Collection<String> getExcludeColumnFieldNames() {
        return this.excludeColumnFieldNames;
    }

    public Collection<Integer> getIncludeColumnIndexes() {
        return this.includeColumnIndexes;
    }

    public Collection<String> getIncludeColumnFieldNames() {
        return this.includeColumnFieldNames;
    }

    public Boolean getOrderByIncludeColumn() {
        return this.orderByIncludeColumn;
    }

    public List<WriteHandler> getWriteHandlerList() {
        return this.writeHandlerList;
    }

    public WorkbookHandlerExecutionChain getOwnWorkbookHandlerExecutionChain() {
        return this.ownWorkbookHandlerExecutionChain;
    }

    public SheetHandlerExecutionChain getOwnSheetHandlerExecutionChain() {
        return this.ownSheetHandlerExecutionChain;
    }

    public WorkbookHandlerExecutionChain getWorkbookHandlerExecutionChain() {
        return this.workbookHandlerExecutionChain;
    }

    public SheetHandlerExecutionChain getSheetHandlerExecutionChain() {
        return this.sheetHandlerExecutionChain;
    }

    public RowHandlerExecutionChain getRowHandlerExecutionChain() {
        return this.rowHandlerExecutionChain;
    }

    public CellHandlerExecutionChain getCellHandlerExecutionChain() {
        return this.cellHandlerExecutionChain;
    }

    public void setNeedHead(Boolean needHead) {
        this.needHead = needHead;
    }

    public void setRelativeHeadRowIndex(Integer relativeHeadRowIndex) {
        this.relativeHeadRowIndex = relativeHeadRowIndex;
    }

    public void setExcelWriteHeadProperty(ExcelWriteHeadProperty excelWriteHeadProperty) {
        this.excelWriteHeadProperty = excelWriteHeadProperty;
    }

    public void setUseDefaultStyle(Boolean useDefaultStyle) {
        this.useDefaultStyle = useDefaultStyle;
    }

    public void setAutomaticMergeHead(Boolean automaticMergeHead) {
        this.automaticMergeHead = automaticMergeHead;
    }

    public void setExcludeColumnIndexes(Collection<Integer> excludeColumnIndexes) {
        this.excludeColumnIndexes = excludeColumnIndexes;
    }

    public void setExcludeColumnFieldNames(Collection<String> excludeColumnFieldNames) {
        this.excludeColumnFieldNames = excludeColumnFieldNames;
    }

    public void setIncludeColumnIndexes(Collection<Integer> includeColumnIndexes) {
        this.includeColumnIndexes = includeColumnIndexes;
    }

    public void setIncludeColumnFieldNames(Collection<String> includeColumnFieldNames) {
        this.includeColumnFieldNames = includeColumnFieldNames;
    }

    public void setOrderByIncludeColumn(Boolean orderByIncludeColumn) {
        this.orderByIncludeColumn = orderByIncludeColumn;
    }

    public void setWriteHandlerList(List<WriteHandler> writeHandlerList) {
        this.writeHandlerList = writeHandlerList;
    }

    public void setOwnWorkbookHandlerExecutionChain(WorkbookHandlerExecutionChain ownWorkbookHandlerExecutionChain) {
        this.ownWorkbookHandlerExecutionChain = ownWorkbookHandlerExecutionChain;
    }

    public void setOwnSheetHandlerExecutionChain(SheetHandlerExecutionChain ownSheetHandlerExecutionChain) {
        this.ownSheetHandlerExecutionChain = ownSheetHandlerExecutionChain;
    }

    public void setWorkbookHandlerExecutionChain(WorkbookHandlerExecutionChain workbookHandlerExecutionChain) {
        this.workbookHandlerExecutionChain = workbookHandlerExecutionChain;
    }

    public void setSheetHandlerExecutionChain(SheetHandlerExecutionChain sheetHandlerExecutionChain) {
        this.sheetHandlerExecutionChain = sheetHandlerExecutionChain;
    }

    public void setRowHandlerExecutionChain(RowHandlerExecutionChain rowHandlerExecutionChain) {
        this.rowHandlerExecutionChain = rowHandlerExecutionChain;
    }

    public void setCellHandlerExecutionChain(CellHandlerExecutionChain cellHandlerExecutionChain) {
        this.cellHandlerExecutionChain = cellHandlerExecutionChain;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractWriteHolder)) {
            return false;
        }
        AbstractWriteHolder other = (AbstractWriteHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$needHead = this.getNeedHead();
        Boolean other$needHead = other.getNeedHead();
        if (this$needHead == null ? other$needHead != null : !((Object)this$needHead).equals(other$needHead)) {
            return false;
        }
        Integer this$relativeHeadRowIndex = this.getRelativeHeadRowIndex();
        Integer other$relativeHeadRowIndex = other.getRelativeHeadRowIndex();
        if (this$relativeHeadRowIndex == null ? other$relativeHeadRowIndex != null : !((Object)this$relativeHeadRowIndex).equals(other$relativeHeadRowIndex)) {
            return false;
        }
        Boolean this$useDefaultStyle = this.getUseDefaultStyle();
        Boolean other$useDefaultStyle = other.getUseDefaultStyle();
        if (this$useDefaultStyle == null ? other$useDefaultStyle != null : !((Object)this$useDefaultStyle).equals(other$useDefaultStyle)) {
            return false;
        }
        Boolean this$automaticMergeHead = this.getAutomaticMergeHead();
        Boolean other$automaticMergeHead = other.getAutomaticMergeHead();
        if (this$automaticMergeHead == null ? other$automaticMergeHead != null : !((Object)this$automaticMergeHead).equals(other$automaticMergeHead)) {
            return false;
        }
        Boolean this$orderByIncludeColumn = this.getOrderByIncludeColumn();
        Boolean other$orderByIncludeColumn = other.getOrderByIncludeColumn();
        if (this$orderByIncludeColumn == null ? other$orderByIncludeColumn != null : !((Object)this$orderByIncludeColumn).equals(other$orderByIncludeColumn)) {
            return false;
        }
        ExcelWriteHeadProperty this$excelWriteHeadProperty = this.getExcelWriteHeadProperty();
        ExcelWriteHeadProperty other$excelWriteHeadProperty = other.getExcelWriteHeadProperty();
        if (this$excelWriteHeadProperty == null ? other$excelWriteHeadProperty != null : !((Object)this$excelWriteHeadProperty).equals(other$excelWriteHeadProperty)) {
            return false;
        }
        Collection<Integer> this$excludeColumnIndexes = this.getExcludeColumnIndexes();
        Collection<Integer> other$excludeColumnIndexes = other.getExcludeColumnIndexes();
        if (this$excludeColumnIndexes == null ? other$excludeColumnIndexes != null : !((Object)this$excludeColumnIndexes).equals(other$excludeColumnIndexes)) {
            return false;
        }
        Collection<String> this$excludeColumnFieldNames = this.getExcludeColumnFieldNames();
        Collection<String> other$excludeColumnFieldNames = other.getExcludeColumnFieldNames();
        if (this$excludeColumnFieldNames == null ? other$excludeColumnFieldNames != null : !((Object)this$excludeColumnFieldNames).equals(other$excludeColumnFieldNames)) {
            return false;
        }
        Collection<Integer> this$includeColumnIndexes = this.getIncludeColumnIndexes();
        Collection<Integer> other$includeColumnIndexes = other.getIncludeColumnIndexes();
        if (this$includeColumnIndexes == null ? other$includeColumnIndexes != null : !((Object)this$includeColumnIndexes).equals(other$includeColumnIndexes)) {
            return false;
        }
        Collection<String> this$includeColumnFieldNames = this.getIncludeColumnFieldNames();
        Collection<String> other$includeColumnFieldNames = other.getIncludeColumnFieldNames();
        if (this$includeColumnFieldNames == null ? other$includeColumnFieldNames != null : !((Object)this$includeColumnFieldNames).equals(other$includeColumnFieldNames)) {
            return false;
        }
        List<WriteHandler> this$writeHandlerList = this.getWriteHandlerList();
        List<WriteHandler> other$writeHandlerList = other.getWriteHandlerList();
        if (this$writeHandlerList == null ? other$writeHandlerList != null : !((Object)this$writeHandlerList).equals(other$writeHandlerList)) {
            return false;
        }
        WorkbookHandlerExecutionChain this$ownWorkbookHandlerExecutionChain = this.getOwnWorkbookHandlerExecutionChain();
        WorkbookHandlerExecutionChain other$ownWorkbookHandlerExecutionChain = other.getOwnWorkbookHandlerExecutionChain();
        if (this$ownWorkbookHandlerExecutionChain == null ? other$ownWorkbookHandlerExecutionChain != null : !((Object)this$ownWorkbookHandlerExecutionChain).equals(other$ownWorkbookHandlerExecutionChain)) {
            return false;
        }
        SheetHandlerExecutionChain this$ownSheetHandlerExecutionChain = this.getOwnSheetHandlerExecutionChain();
        SheetHandlerExecutionChain other$ownSheetHandlerExecutionChain = other.getOwnSheetHandlerExecutionChain();
        if (this$ownSheetHandlerExecutionChain == null ? other$ownSheetHandlerExecutionChain != null : !((Object)this$ownSheetHandlerExecutionChain).equals(other$ownSheetHandlerExecutionChain)) {
            return false;
        }
        WorkbookHandlerExecutionChain this$workbookHandlerExecutionChain = this.getWorkbookHandlerExecutionChain();
        WorkbookHandlerExecutionChain other$workbookHandlerExecutionChain = other.getWorkbookHandlerExecutionChain();
        if (this$workbookHandlerExecutionChain == null ? other$workbookHandlerExecutionChain != null : !((Object)this$workbookHandlerExecutionChain).equals(other$workbookHandlerExecutionChain)) {
            return false;
        }
        SheetHandlerExecutionChain this$sheetHandlerExecutionChain = this.getSheetHandlerExecutionChain();
        SheetHandlerExecutionChain other$sheetHandlerExecutionChain = other.getSheetHandlerExecutionChain();
        if (this$sheetHandlerExecutionChain == null ? other$sheetHandlerExecutionChain != null : !((Object)this$sheetHandlerExecutionChain).equals(other$sheetHandlerExecutionChain)) {
            return false;
        }
        RowHandlerExecutionChain this$rowHandlerExecutionChain = this.getRowHandlerExecutionChain();
        RowHandlerExecutionChain other$rowHandlerExecutionChain = other.getRowHandlerExecutionChain();
        if (this$rowHandlerExecutionChain == null ? other$rowHandlerExecutionChain != null : !((Object)this$rowHandlerExecutionChain).equals(other$rowHandlerExecutionChain)) {
            return false;
        }
        CellHandlerExecutionChain this$cellHandlerExecutionChain = this.getCellHandlerExecutionChain();
        CellHandlerExecutionChain other$cellHandlerExecutionChain = other.getCellHandlerExecutionChain();
        return !(this$cellHandlerExecutionChain == null ? other$cellHandlerExecutionChain != null : !((Object)this$cellHandlerExecutionChain).equals(other$cellHandlerExecutionChain));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractWriteHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $needHead = this.getNeedHead();
        result = result * 59 + ($needHead == null ? 43 : ((Object)$needHead).hashCode());
        Integer $relativeHeadRowIndex = this.getRelativeHeadRowIndex();
        result = result * 59 + ($relativeHeadRowIndex == null ? 43 : ((Object)$relativeHeadRowIndex).hashCode());
        Boolean $useDefaultStyle = this.getUseDefaultStyle();
        result = result * 59 + ($useDefaultStyle == null ? 43 : ((Object)$useDefaultStyle).hashCode());
        Boolean $automaticMergeHead = this.getAutomaticMergeHead();
        result = result * 59 + ($automaticMergeHead == null ? 43 : ((Object)$automaticMergeHead).hashCode());
        Boolean $orderByIncludeColumn = this.getOrderByIncludeColumn();
        result = result * 59 + ($orderByIncludeColumn == null ? 43 : ((Object)$orderByIncludeColumn).hashCode());
        ExcelWriteHeadProperty $excelWriteHeadProperty = this.getExcelWriteHeadProperty();
        result = result * 59 + ($excelWriteHeadProperty == null ? 43 : ((Object)$excelWriteHeadProperty).hashCode());
        Collection<Integer> $excludeColumnIndexes = this.getExcludeColumnIndexes();
        result = result * 59 + ($excludeColumnIndexes == null ? 43 : ((Object)$excludeColumnIndexes).hashCode());
        Collection<String> $excludeColumnFieldNames = this.getExcludeColumnFieldNames();
        result = result * 59 + ($excludeColumnFieldNames == null ? 43 : ((Object)$excludeColumnFieldNames).hashCode());
        Collection<Integer> $includeColumnIndexes = this.getIncludeColumnIndexes();
        result = result * 59 + ($includeColumnIndexes == null ? 43 : ((Object)$includeColumnIndexes).hashCode());
        Collection<String> $includeColumnFieldNames = this.getIncludeColumnFieldNames();
        result = result * 59 + ($includeColumnFieldNames == null ? 43 : ((Object)$includeColumnFieldNames).hashCode());
        List<WriteHandler> $writeHandlerList = this.getWriteHandlerList();
        result = result * 59 + ($writeHandlerList == null ? 43 : ((Object)$writeHandlerList).hashCode());
        WorkbookHandlerExecutionChain $ownWorkbookHandlerExecutionChain = this.getOwnWorkbookHandlerExecutionChain();
        result = result * 59 + ($ownWorkbookHandlerExecutionChain == null ? 43 : ((Object)$ownWorkbookHandlerExecutionChain).hashCode());
        SheetHandlerExecutionChain $ownSheetHandlerExecutionChain = this.getOwnSheetHandlerExecutionChain();
        result = result * 59 + ($ownSheetHandlerExecutionChain == null ? 43 : ((Object)$ownSheetHandlerExecutionChain).hashCode());
        WorkbookHandlerExecutionChain $workbookHandlerExecutionChain = this.getWorkbookHandlerExecutionChain();
        result = result * 59 + ($workbookHandlerExecutionChain == null ? 43 : ((Object)$workbookHandlerExecutionChain).hashCode());
        SheetHandlerExecutionChain $sheetHandlerExecutionChain = this.getSheetHandlerExecutionChain();
        result = result * 59 + ($sheetHandlerExecutionChain == null ? 43 : ((Object)$sheetHandlerExecutionChain).hashCode());
        RowHandlerExecutionChain $rowHandlerExecutionChain = this.getRowHandlerExecutionChain();
        result = result * 59 + ($rowHandlerExecutionChain == null ? 43 : ((Object)$rowHandlerExecutionChain).hashCode());
        CellHandlerExecutionChain $cellHandlerExecutionChain = this.getCellHandlerExecutionChain();
        result = result * 59 + ($cellHandlerExecutionChain == null ? 43 : ((Object)$cellHandlerExecutionChain).hashCode());
        return result;
    }

    public AbstractWriteHolder() {
    }
}

