/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetAsyncStatusResponse
implements JsonpSerializable {
    private final String id;
    private final boolean isRunning;
    private final boolean isPartial;
    private final long startTimeInMillis;
    private final long expirationTimeInMillis;
    @Nullable
    private final Number completionStatus;
    public static final JsonpDeserializer<GetAsyncStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAsyncStatusResponse::setupGetAsyncStatusResponseDeserializer);

    private GetAsyncStatusResponse(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.isRunning = ApiTypeHelper.requireNonNull(builder.isRunning, this, "isRunning");
        this.isPartial = ApiTypeHelper.requireNonNull(builder.isPartial, this, "isPartial");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.expirationTimeInMillis = ApiTypeHelper.requireNonNull(builder.expirationTimeInMillis, this, "expirationTimeInMillis");
        this.completionStatus = builder.completionStatus;
    }

    public static GetAsyncStatusResponse of(Function<Builder, ObjectBuilder<GetAsyncStatusResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public final long expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    @Nullable
    public final Number completionStatus() {
        return this.completionStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("expiration_time_in_millis");
        generator.write(this.expirationTimeInMillis);
        if (this.completionStatus != null) {
            generator.writeKey("completion_status");
            generator.write(this.completionStatus.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetAsyncStatusResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(Builder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::expirationTimeInMillis, JsonpDeserializer.longDeserializer(), "expiration_time_in_millis");
        op.add(Builder::completionStatus, JsonpDeserializer.numberDeserializer(), "completion_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetAsyncStatusResponse> {
        private String id;
        private Boolean isRunning;
        private Boolean isPartial;
        private Long startTimeInMillis;
        private Long expirationTimeInMillis;
        @Nullable
        private Number completionStatus;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder isRunning(boolean value) {
            this.isRunning = value;
            return this;
        }

        public final Builder isPartial(boolean value) {
            this.isPartial = value;
            return this;
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder expirationTimeInMillis(long value) {
            this.expirationTimeInMillis = value;
            return this;
        }

        public final Builder completionStatus(@Nullable Number value) {
            this.completionStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetAsyncStatusResponse build() {
            this._checkSingleUse();
            return new GetAsyncStatusResponse(this);
        }
    }
}

