/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;

@JsonpDeserializable
public class ByteArrayBinaryData
implements BinaryData {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final String contentType;
    public static final JsonpDeserializer<ByteArrayBinaryData> _DESERIALIZER = new Deserializer();

    ByteArrayBinaryData(byte[] bytes, int offset, int length, String contentType) {
        this.contentType = contentType;
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    ByteArrayBinaryData(byte[] bytes, String contentType) {
        this.contentType = contentType;
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public ByteArrayBinaryData(BinaryData data) throws IOException {
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
        data.writeTo(out);
        this.contentType = data.contentType();
        this.bytes = out.array();
        this.offset = 0;
        this.length = out.size();
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, this.offset, this.length);
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.offset, this.length);
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    private static class Deserializer
    extends JsonpDeserializerBase<ByteArrayBinaryData> {
        Deserializer() {
            super(EnumSet.allOf(JsonParser.Event.class));
        }

        @Override
        public ByteArrayBinaryData deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
            JsonpUtils.copy(parser, generator, event);
            generator.close();
            return new ByteArrayBinaryData(baos.toByteArray(), "application/json");
        }
    }
}

